#ifndef __included_packet_backpack_h__
#define __included_packet_backpack_h__

#include <nl.h>
#include "backpack.inc"
#include "weapon.inc"

#define sizeof_packet_backpack_new_begin	(1+1)
#define sizeof_packet_backpack_new		(4+2+2+2+4+4)

struct packet_backpack_new {
    int time;

    backpack_id id;
    double x, y;
    double vx, vy;
};

struct packet_backpack_taken {
    int time;

    backpack_id id;

    /* Optional: */
    unsigned int ammo[NUM_WEAPON_CLASSES];
};


extern NLint
packet_backpack_new_begin_encode(const int num,
				 NLbyte *buf, const NLint sz);
extern NLint
packet_backpack_new_begin_decode(int *num,
				 const NLbyte *buf, const NLint sz);
extern NLint
packet_backpack_new_encode(const struct packet_backpack_new *packet,
			   NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_backpack_new_decode(struct packet_backpack_new *packet,
			   const NLbyte *buf, const NLint sz, NLint count);
extern NLint packet_backpack_taken_encode(const struct packet_backpack_taken *,
					  const bool local,
					  NLbyte *buf, NLint size);
extern void packet_backpack_taken_decode(struct packet_backpack_taken *packet,
					 const bool local,
					 const NLbyte *buf, const NLint size);

#endif
