#ifndef __included_network_h__
#define __included_network_h__

#include <stdbool.h>

enum CLIENT_SERVER_MODE {
    I_AM_SERVER_ONLY,
    I_AM_CLIENT_ONLY,
    I_AM_CLIENT_SERVER,
    I_AM_MENU
};


extern enum CLIENT_SERVER_MODE client_server_mode;

#define MAX_PACKET_SIZE			256

/*--------------------------------------------------------------*/
/* This is a list of commands that the server may send to a client.
 * Each command may also come with a data structure.
 */

#define COMMAND_SERVER_STATE	'S'
#define COMMAND_SET_CLOCK	't'
#define COMMAND_MAP		'?'
#define COMMAND_SET_ZERO	'0'
#define COMMAND_START_LOC	'l'
#define COMMAND_START_LOCS	'L'

#define COMMAND_PLAYER_NEW	'@'
#define COMMAND_PLAYER_ATTACH	'_'
#define COMMAND_PLAYER_UPDATEL	'o'
#define COMMAND_PLAYER_UPDATEL2	'O'
#define COMMAND_PLAYER_UPDATER	'c'
#define COMMAND_PLAYER_UPDATER2	'C'
#define COMMAND_PLAYER_RESPAWN	'&'
#define COMMAND_PLAYER_DIE	'%'
#define COMMAND_DISCONNECT	'd'

#define COMMAND_BULLET_NEW	'*'
#define COMMAND_BULLET_DIE	'/'

#define COMMAND_PICKUP_NEW	'!'
#define COMMAND_PICKUP_QUAFF	'q'

#define COMMAND_BACKPACK_NEW	's'
#define COMMAND_BACKPACK_TAKE	'('
#define COMMAND_BACKPACK_TAKEN	')'

#define COMMAND_EXPLOSION_NEW	'e'
#define COMMAND_EXPLOSION_DIE	'E'

#define COMMAND_CONTAINER_NEW	'{'
#define COMMAND_CONTAINER_SHOW	'|'
#define COMMAND_CONTAINER_HIDE	'}'

#define COMMAND_GIZMO_NEW	'g'

#define COMMAND_CANDELA_NEW	'i'

#define COMMAND_BLEED		'b'

/*--------------------------------------------------------------*/
/* This is a list of commands a client may send to the server.
 */

#define MAX_CHAT_LEN		50 /*(MAX_PACKET_SIZE-1)*/

#define COMMAND_INPUT_INFO	'i'
#define COMMAND_INPUT_INFO2	'I'
#define COMMAND_INPUT_MOVE	'm'
#define COMMAND_INPUT_WIELD	'w'
#define COMMAND_INPUT_CHAT	'"'
#define COMMAND_INPUT_EDITOR	'#'
#define COMMAND_INPUT_DISCONNECT	'~'

/* Asking server for commands. */
#define COMMAND_SERVER		':'

/*--------------------------------------------------------------*/

extern int zero_tx, zero_ty;	/* tiles */
extern double zero_x, zero_y;	/* pixels */

extern void network_print_error(const char *module, const int ln);
extern bool network_init(void);
extern void network_shutdown(void);

#endif
