#ifndef __included_map_h__
#define __included_map_h__

#include <stdbool.h>

#include "game-state.h"
#include "region.inc"

#define NUM_TILES	36
#define TILE_W		32
#define TILE_W_2	(TILE_W/2)
#define TILE_H		32
#define TILE_H_2	(TILE_H/2)
#define MAP_W_TILES	(640.0/TILE_W)
#define MAP_H_TILES	(480.0/TILE_H)

enum TILE_FACE {
    TILE_FACE_RIGHT,
    TILE_FACE_TOP,
    TILE_FACE_LEFT,
    TILE_FACE_BOTTOM,
};

typedef struct {
    unsigned int shape;
    region_id region;		/* Extra help for robots */
} map_tile_t;

typedef struct {
    int w, h;
    int alloc_w, alloc_h;

    /* 2d array. */
    map_tile_t **tile;
} map_t;

extern map_t map;

extern bool map_occupies(const int x, const int y);
extern bool tile_in_map(const int x, const int y);
extern bool x_in_map(const int x);
extern bool y_in_map(const int y);
extern float normal_angle(const int x, const int y, const enum TILE_FACE e);
extern void map_set_tile(int x, int y, const unsigned int tile,
			 game_state_t *state);
extern void map_set_tiles(const int x, const int y, const unsigned int tile,
			  const unsigned char brush_size, game_state_t *state);
extern bool map_is_different(const int x, const int y, const unsigned int tile,
			     const unsigned char brush_size);
extern unsigned int map_select_tile(const int tile);
extern void map_set_regions(const int X0, const int Y0, const region_id region,
			    const unsigned char brush_size);
extern void map_bind_tiles(void);
extern void map_draw(void);
extern void map_draw_tile(const int nth, const int x, const int y);
extern void map_resize_h(const int rows);
extern void map_resize_w(const int cols);
extern void map_shift(const int dx, const int dy, game_state_t *state);
extern void map_init(void);
extern void map_shutdown(void);

#endif
