#ifndef __included_lux_h__
#define __included_lux_h__

#include <GL/gl.h>

typedef struct lux {
    struct lux *next;
    struct lux *prev;

    /* Spawn state. */
    double _spawn_x, _spawn_y;
    GLfloat _spawn_colour[4];
    int _spawn_life;		/* msec */

    /* Current state. */
    GLfloat colour[4];
    int life;			/* msec */
    double r;
} lux_t;


extern void lux_update(void);
extern void lux_draw(void);
extern lux_t *lux_new(const double x, const double y, const int life,
		      const GLfloat col[4]);
extern void lux_automate(lux_t *l);
extern void lux_start(void);
extern void lux_stop(void);

#endif
