#ifndef __included_container_h__
#define __included_container_h__

#include <stdbool.h>
#include "game-state.h"
#include "packet-container.h"
#include "player.inc"
#include "list.h"

typedef struct container {
    struct container *next;
    struct container *prev;

    container_id id;
    enum CONTAINER_CLASS class;

    int health;
    bool hidden;
    double x, y;
    int respawn_time;

    bool highlight;
} container_t;


extern list_head_t container_list;

extern bool container_in_tile(const enum CONTAINER_CLASS c,
			      const int x, const int y);
extern void container_hurt(const container_id id, const int damage,
			   const player_id hurter, const int tick,
			   game_state_t *state);
extern void container_update(game_state_t *state);
extern void container_bind_texture(void);
extern void container_draw(const bool editor_enabled);
extern void container_draw_unit(enum CONTAINER_CLASS class,
				const int x, const int y, const bool for_game);
extern container_t *container_from_id(container_id id);
extern container_id container_bounding(const int x, const int y,
				       const bool skip_hidden);
extern enum CONTAINER_CLASS container_select(const int n);
extern container_id container_generate_unique_id(void);
extern int container_total(void);
extern void container_new(const struct packet_container_new *packet);
extern void container_move(const struct packet_container_mov *packet);
extern void container_shift(const double offx, const double offy);
extern void container_delete(const struct packet_container_del *packet);
extern void container_start(void);
extern void container_stop(void);
extern void container_init(void);
extern void container_shutdown(void);

#endif
