#ifndef __included_client_h__
#define __included_client_h__

#include <nl.h>
#include <stdbool.h>

#include "game-state.h"
#include "player.h"

extern NLsocket client_sock(void);
extern bool client_write(const NLvoid *buf, NLint nbytes);
extern void client_send_chat(const char *buf);
extern void client_send_command(const char *buf);
extern void client_incoming(game_state_t *state);
extern void client_outgoing(const player_t *p, const int impy,
			    const enum WEAPON_CLASS select_weapon);
extern void client_request_disconnect(void);
extern bool client_init(const char *name, const char *addr_str);
extern void client_shutdown(void);

#endif
