#ifndef __included_chat_h__
#define __included_chat_h__

#include <stdbool.h>

#include "network.h"

#define NUM_CHAT_HISTORY	32
#define NUM_CHAT_CLASSES	7

enum CHAT_MESSAGE_CLASS {
    /* Error messages. */
    CHAT_SERVER_ERROR,
    CHAT_FRONTEND_ERROR,
    CHAT_CLIENT_ERROR,

    /* Server log (game started, etc). */
    CHAT_SERVER_LOG,

    /* Frontend log (usage, etc). */
    CHAT_FRONTEND_LOG,

    /* Automatically generated game messages (player deaths, etc). */
    CHAT_GAME_MESSAGE,

    /* Clients talking to each other. */
    CHAT_BABBLE
};

typedef struct {
    int time;
    enum CHAT_MESSAGE_CLASS class;
    char *str;
} chat_t;


extern bool input_enabled;
extern char input_line[MAX_CHAT_LEN];
extern bool chat_new_messages;

extern int chat_colour_from_class(const enum CHAT_MESSAGE_CLASS c);
extern const char *chat_input(const int c, const int sc);
extern void chat_scroll(const int tick);
extern void chat_add(const int tick, const enum CHAT_MESSAGE_CLASS class,
		     const char *format, ...);
extern const chat_t *chat_get(const unsigned int i);
extern unsigned int chat_num_lines(void);
extern void chat_init(void);
extern void chat_init_colours(void);
extern void chat_shutdown(void);

#endif
