/* sv-status.c,
 *
 * The status bar for the text interface server.
 */

#include <assert.h>
#include <curses.h>

#include "strlcpy.h"
#include "textface/sv-status.h"
#include "textface/sv-textface.h"


static char status_line[128];

/*--------------------------------------------------------------*/

void sv_status_repaint(void)
{
    bkgdset(COLOR_PAIR(PAIR_STATUS));
    mvaddstr(STATUS_ROW, 0,
	     status_line[0] ? status_line : "Red Pixel server");
    clrtoeol();
    bkgdset(A_NORMAL);
}

/*--------------------------------------------------------------*/

void sv_status_set(const char *text)
{
    if (!text)
	status_line[0] = '\0';
    else
	strlcpy(status_line, text, sizeof(status_line));
}

/*--------------------------------------------------------------*/

void sv_status_init(void)
{
    status_line[0] = '\0';
}


void sv_status_shutdown(void)
{
}
