/* stats-particle.c,
 *
 * Extra stats about different particle types.
 */

#include <assert.h>
#include <stdlib.h>
#include "stats-particle.h"


const part_cat_stats_t particle_category[NUM_PARTICLE_CATEGORIES] = {
    /* Blood */
    { 50, PARTICLE_BLOOD1,	PARTICLE_BLOOD5,
      250, 3.5, {1.0, 0.0, 0.2, 0.25} },

    /* Respawning */
    {100, PARTICLE_RESPAWNING1,	PARTICLE_RESPAWNING2,
     1500, 24.0, {0.2, 0.4, 1.0, 0.40} },

    /* Spark */
    { 10, PARTICLE_SPARK1,	PARTICLE_SPARK1,
      150, 3.0, {1.0, 1.0, 0.5, 0.20} }
};

const particle_stats_t particle_stats[NUM_PARTICLE_CLASSES] = {
    /* Blood */
    { 50, 5000, 5000, 150, 50, { 0.6, 0.0, 0.0 } },
    { 55, 5000, 5000, 175, 50, { 0.4, 0.0, 0.0 } },
    { 60, 5000, 5000, 200, 50, { 0.4, 0.0, 0.1 } },
    { 65, 5000, 5000, 225, 50, { 0.2, 0.0, 0.0 } },
    { 70, 5000, 5000, 250, 50, { 0.2, 0.0, 0.1 } },

    /* Respawning */
    { 500, 400,  300, 200, 100, { 0.2, 0.2, 1.0 } },
    { 500, 400,  300, 250,  50, { 0.4, 0.4, 1.0 } },

    /* Spark */
    { 50, 1000, 1000, 150, 50, { 0.8, 0.5, 0.2 } }
};

/*--------------------------------------------------------------*/

enum PARTICLE_CLASS
particle_class_from_category(const enum PARTICLE_CATEGORY cat)
{
    int range;
    assert(cat < NUM_PARTICLE_CATEGORIES);

    range = particle_category[cat].upper - particle_category[cat].lower + 1;
    assert(range > 0);

    return (particle_category[cat].lower + rand()%range);
}
