/* stats-gizmo.c,
 *
 * Extra stats about individual gizmos.
 */

#include <assert.h>
#include "stats-gizmo.h"


static const char gizmo_symbol[NUM_GIZMO_CLASSES] = {
    /* Ladders */
     0,  1,  2,  3,  4,
    10, 11, 12, 13, 14,
    20, 21, 22, 23, 24,

    /* Springs */
    30
};

const sprite_t gizmo_sprite[NUM_GIZMO_CLASSES] = {
    /* Ladders */
    {  21,   2,  64,  64 },	/* LADDER */
    {  21,   2,  64, 128 },
    {  21,   2,  64, 192 },
    {  21,   2,  64, 256 },
    {  21,   2,  64, 320 },
    {   2,   2,  16,  64 },	/* LADDERR */
    {   2,   2,  16, 128 },
    {   2,   2,  16, 192 },
    {   2,   2,  16, 256 },
    {   2,   2,  16, 320 },
    {  88,   2,  16,  64 },	/* LADDERL */
    {  88,   2,  16, 128 },
    {  88,   2,  16, 192 },
    {  88,   2,  16, 256 },
    {  88,   2,  16, 320 },

    /* Springs */
    {   2, 325,  40,  13 }
};

/*--------------------------------------------------------------*/

enum GIZMO_CLASS gizmo_class_from_symbol(const char symbol)
{
    enum GIZMO_CLASS g;

    for (g = 0; g < NUM_GIZMO_CLASSES; g++) {
	if (gizmo_symbol[g] == symbol)
	    return g;
    }

    return GIZMO_LADDER;
}


char gizmo_class_to_symbol(const enum GIZMO_CLASS g)
{
    assert(g < NUM_GIZMO_CLASSES);
    return gizmo_symbol[g];
}
