/* stats-container.c,
 *
 * Extra stats about individual containers.
 */

#include <assert.h>
#include "stats-container.h"


#define NOT_EXPLOSIVE		{false, 0.0, 0.0}

const container_stats_t container_stats[NUM_CONTAINER_CLASSES] = {
    /* Barrels */
    {  0,  8000, 20, {true, 150, 50}, MEAT_FROM_BARREL, EXPLOSION_SMALL },
    {  1, 10000, 30, {true, 175, 60}, MEAT_FROM_BARREL, EXPLOSION_SMALL },
    {  2, 12000, 40, {true, 200, 70}, MEAT_FROM_BARREL, EXPLOSION_SMALL },
    { 10,  8000, 20, {true, 150, 50}, MEAT_FROM_BARREL, EXPLOSION_SMALL },
    { 11, 10000, 30, {true, 175, 60}, MEAT_FROM_BARREL, EXPLOSION_SMALL },
    { 12, 12000, 40, {true, 200, 70}, MEAT_FROM_BARREL, EXPLOSION_SMALL },
    { 20,  8000, 20, {true, 150, 50}, MEAT_FROM_BARREL_RED, EXPLOSION_SMALL },
    { 21, 10000, 30, {true, 175, 60}, MEAT_FROM_BARREL_RED, EXPLOSION_SMALL },
    { 22, 12000, 40, {true, 200, 70}, MEAT_FROM_BARREL_RED, EXPLOSION_SMALL },

    /* Crates */
    { 30,  8000, 10, NOT_EXPLOSIVE, MEAT_FROM_CRATE, EXPLOSION_SMALL },
    { 31, 10000, 20, NOT_EXPLOSIVE, MEAT_FROM_CRATE, EXPLOSION_SMALL },
    { 32, 12000, 30, NOT_EXPLOSIVE, MEAT_FROM_CRATE, EXPLOSION_SMALL }
};

#undef NOT_EXPLOSIVE


const sprite_t container_sprite[NUM_CONTAINER_CLASSES] = {
    /* Barrels */
    {   2,   2, 42, 44 },
    {  47,   2, 52, 54 },
    { 102,   2, 62, 64 },
    {   2,  69, 42, 44 },
    {  47,  69, 52, 54 },
    { 102,  69, 62, 64 },
    {   2, 136, 42, 44 },
    {  47, 136, 52, 54 },
    { 102, 136, 62, 64 },

    /* Crates */
    {   2, 203, 47, 45 },
    {  52, 203, 62, 50 },
    { 117, 203, 82, 55 }
};

/*--------------------------------------------------------------*/

enum CONTAINER_CLASS container_class_from_symbol(const char symbol)
{
    enum CONTAINER_CLASS c;

    for (c = 0; c < NUM_CONTAINER_CLASSES; c++) {
	if (container_stats[c].symbol == symbol)
	    return c;
    }

    return CONTAINER_BARREL;
}


char container_class_to_symbol(const enum CONTAINER_CLASS c)
{
    assert(c < NUM_CONTAINER_CLASSES);

    return container_stats[c].symbol;
}

/*--------------------------------------------------------------*/

bool container_is_explosive(const enum CONTAINER_CLASS c)
{
    assert(c < NUM_CONTAINER_CLASSES);
    return container_stats[c].explosion.explosive;
}
