/* packet-server.c,
 *
 * Convert server command packets to/from a buffer, to be sent across
 * the network.
 */

#include <assert.h>

#include "network.h"
#include "packet-server.h"


/*--------------------------------------------------------------*/

NLint packet_server_state_encode(const game_state_t *packet,
				 NLbyte *buf, NLint size)
{
    NLint count = 0;

    writeByte(buf, count, COMMAND_SERVER_STATE);
    writeByte(buf, count, packet->game_mode);
    writeByte(buf, count, packet->next_game_mode);
    writeByte(buf, count, packet->context);
    writeByte(buf, count, packet->editor_enabled);

    assert(count <= size);
    return count;
}


void packet_server_state_decode(game_state_t *packet,
				const NLbyte *buf, const NLint size)
{
    NLint count = 1;

    readByte(buf, count, packet->game_mode);
    readByte(buf, count, packet->next_game_mode);
    readByte(buf, count, packet->context);
    readByte(buf, count, packet->editor_enabled);

    if (packet->context == SERVER_IN_LOBBY)
	packet->game_mode = packet->next_game_mode;

    assert(count == size);
}

/*--------------------------------------------------------------*/

NLint packet_set_clock_encode(const struct packet_set_clock *packet,
			      NLbyte *buf, NLint size)
{
    NLint count = 0;

    writeByte(buf, count, COMMAND_SET_CLOCK);
    writeLong(buf, count, packet->time);

    assert(count <= size);
    return count;
}


void packet_set_clock_decode(struct packet_set_clock *packet,
			     const NLbyte *buf, const NLint size)
{
    NLint count = 1;

    readLong(buf, count, packet->time);

    assert(count == size);
}

/*--------------------------------------------------------------*/

NLint packet_server_encode(const NLbyte *string, NLbyte *buf, NLint size)
{
    NLint count = 0;

    writeByte(buf, count, COMMAND_SERVER);
    writeString(buf, count, string);

    assert(count <= size);
    return count;
}


void packet_server_decode(NLbyte *string, const NLbyte *buf, const NLint size)
{
    NLint count = 1;

    readString(buf, count, string);

    assert(count == size);
}
