/* packet-gizmo.c,
 *
 * Convert bullet command packets to/from a buffer, to be sent across
 * the network.
 */

#include <assert.h>
#include "network.h"
#include "packet-gizmo.h"
#include "stats-gizmo.h"


/*--------------------------------------------------------------*/

NLint packet_gizmo_new_begin_encode(const int num,
				    NLbyte *buf, const NLint sz)
{
    NLint count = 0;
    assert(num > 0);
    assert(buf);

    writeByte(buf, count, COMMAND_GIZMO_NEW);
    writeByte(buf, count, num);

    assert(count <= sz);
    return count;
}


NLint packet_gizmo_new_begin_decode(int *num,
				    const NLbyte *buf, const NLint sz)
{
    NLint count = 1;
    int n;
    assert(num);
    assert(buf);

    readByte(buf, count, n); *num = n;

    assert(count <= sz);
    return count;
}


NLint packet_gizmo_new_encode(const struct packet_gizmo_new *packet,
			      NLbyte *buf, const NLint sz, NLint count)
{
    int xx, yy;
    char symbol = gizmo_class_to_symbol(packet->class);
    assert(packet);
    assert(buf);

    xx = packet->x + zero_x;
    yy = packet->y + zero_y;

    writeGizmoID(buf, count, packet->id);
    writeGizmoClass(buf, count, symbol);
    writeShort(buf, count, xx);
    writeShort(buf, count, yy);

    assert(count <= sz);
    return count;
}


NLint packet_gizmo_new_decode(struct packet_gizmo_new *packet,
			      const NLbyte *buf, const NLint sz, NLint count)
{
    int xx, yy;
    char symbol;
    assert(packet);
    assert(buf);

    readGizmoID(buf, count, packet->id);
    readGizmoClass(buf, count, symbol);
    packet->class = gizmo_class_from_symbol(symbol);
    readShort(buf, count, xx); packet->x = xx - zero_x;
    readShort(buf, count, yy); packet->y = yy - zero_y;

    assert(count <= sz);
    return count;
}

/*--------------------------------------------------------------*/
/* Map editor only.						*/
/*--------------------------------------------------------------*/

NLint packet_gizmo_mov_encode(const struct packet_gizmo_mov *packet,
			      NLbyte *buf, NLint size)
{
    NLint count = 0;
    int xx = packet->x + zero_x;
    int yy = packet->y + zero_y;

    writeGizmoID(buf, count, packet->id);
    writeShort(buf, count, xx);
    writeShort(buf, count, yy);

    assert(count <= size);
    return count;
}


void packet_gizmo_mov_decode(struct packet_gizmo_mov *packet,
			     const NLbyte *buf, const NLint size)
{
    NLint count = 0;
    int xx, yy;

    readGizmoID(buf, count, packet->id);
    readShort(buf, count, xx); packet->x = xx - zero_x;
    readShort(buf, count, yy); packet->y = yy - zero_y;

    assert(count == size);
}

/*--------------------------------------------------------------*/

NLint packet_gizmo_del_encode(const struct packet_gizmo_del *packet,
			      NLbyte *buf, NLint size)
{
    NLint count = 0;

    writeGizmoID(buf, count, packet->id);

    assert(count <= size);
    return count;
}


void packet_gizmo_del_decode(struct packet_gizmo_del *packet,
			     const NLbyte *buf, const NLint size)
{
    NLint count = 0;

    readGizmoID(buf, count, packet->id);

    assert(count == size);
}
