/* packet-explosion.c,
 *
 * Convert explosion command packets to/from a buffer, to be sent
 * across the network.
 */

#include <assert.h>
#include "network.h"
#include "packet-explosion.h"


/*--------------------------------------------------------------*/

NLint packet_explosion_new_encode(const struct packet_explosion_new *packet,
				  NLbyte *buf, NLint size)
{
    NLint count = 0;
    int xx = packet->x + zero_x;
    int yy = packet->y + zero_y;

    writeByte (buf, count, COMMAND_EXPLOSION_NEW);
    writeLong (buf, count, packet->time);
    writeExplosionID(buf, count, packet->id);
    writeShort(buf, count, xx);
    writeShort(buf, count, yy);
    writeFloat(buf, count, packet->max_r);

    assert(count <= size);
    return count;
}


void packet_explosion_new_decode(struct packet_explosion_new *packet,
				 const NLbyte *buf, const NLint size)
{
    NLint count = 1;
    int xx, yy;

    readLong (buf, count, packet->time);
    readExplosionID(buf, count, packet->id);
    readShort(buf, count, xx); packet->x = xx - zero_x;
    readShort(buf, count, yy); packet->y = yy - zero_y;
    readFloat(buf, count, packet->max_r);

    packet->damage = 1.0;
    packet->modifier = 1.0;

    assert(count == size);
}


/*--------------------------------------------------------------*/

NLint packet_explosion_die_encode(const struct packet_explosion_die *packet,
				  NLbyte *buf, NLint size)
{
    NLint count = 0;

    writeByte (buf, count, COMMAND_EXPLOSION_DIE);
    writeExplosionID(buf, count, packet->id);

    assert(count <= size);
    return count;
}


void packet_explosion_die_decode(struct packet_explosion_die *packet,
				 const NLbyte *buf, const NLint size)
{
    NLint count = 1;

    readExplosionID(buf, count, packet->id);

    assert(count == size);
}
