/* packet-candy.c,
 *
 * Convert eye-candy command packets to/from a buffer, to be sent
 * across the network.
 */

#include <assert.h>
#include "network.h"
#include "packet-candy.h"


/*--------------------------------------------------------------*/

NLint packet_bleeding_encode(const struct packet_bleeding *packet,
			     NLbyte *buf, NLint size)
{
    NLint count = 0;
    int xx = packet->x + zero_x;
    int yy = packet->y + zero_y;

    writeByte (buf, count, COMMAND_BLEED);
    writeLong (buf, count, packet->time);
    writeShort(buf, count, xx);
    writeShort(buf, count, yy);

    assert(count <= size);
    return count;
}


void packet_bleeding_decode(struct packet_bleeding *packet,
			    const NLbyte *buf, const NLint size)
{
    NLint count = 1;
    int xx, yy;

    readLong (buf, count, packet->time);
    readShort(buf, count, xx); packet->x = xx - zero_x;
    readShort(buf, count, yy); packet->y = yy - zero_y;

    assert(count == size);
}
