/* menu-root.c,
 *
 * The initial menu.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>

#include "menu/menu-play.h"
#include "menu/menu-root.h"
#include "menu/widget.h"

/*--------------------------------------------------------------*/

static int multiplayer_callback(DIALOG *_);


DIALOG root_dialog[] = {
    /* proc, x, y, w, h, fg, bg, key, flags, d1, d2, dp1, dp2, dp3 */
    { d_ctext_proc,
      0, 50, 640, 40,
      -0xff2020, -0x000000,
      0, 0, 0, 0,
      "Red Pixel III", NULL, NULL },

    { d_aalg_push_proc,
      150, 150, 340, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "Multiplayer", NULL, multiplayer_callback },

    { d_button_proc,
      150, 200, 340, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "( Options )", NULL, NULL },

    { d_button_proc,
      150, 250, 340, 40,
      -0xffffff, -0x202020,
      0, 0, 0, 0,
      "( Credits )", NULL, NULL },

    { d_button_proc,
      150, 300, 340, 40,
      -0xffffff, -0x202020,
      0, D_EXIT, 0, 0,
      "Quit", NULL, NULL },

    { d_algl_hack_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { d_yield_proc,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
    { NULL,		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

/*--------------------------------------------------------------*/

static int multiplayer_callback(DIALOG *_)
{
    (void)_;

    algl_do_dialog_nested(play_dialog, 1);

    return D_O_K;
}
