/* game-state.c,
 *
 * Wrapper for variables not shared between client and server threads.
 */

#include <assert.h>
#include <stdlib.h>

#include "game-state.h"
#include "strlcpy.h"


const char *game_mode_str[NUM_GAME_MODES] = {
    "Deathmatch",
    "Silhouettes",
};

/*--------------------------------------------------------------*/

const char *game_mode_str_from_mode(const enum GAME_MODE mode)
{
    if (mode >= NUM_GAME_MODES) {
	return "Unknown";
    }
    else {
	return game_mode_str[mode];
    }
}

/*--------------------------------------------------------------*/

void game_state_init(game_state_t *state, const enum GAME_MODE mode,
		     const bool as_server)
{
    assert(state);

    state->as_server = as_server;
    state->context = SERVER_IN_LOBBY;
    state->game_mode = mode;
    state->editor_enabled = false;
    strlcpy(state->next_map, "test.map", sizeof(state->next_map));

    list_init(state->backpack_list);
    list_init(state->bullet_list);
    list_init(state->explosion_list);
    list_init(state->player_list);
}
