/* common.c,
 *
 * Common game variables.
 */

#include <alleggl.h>
#include <allegro.h>
#include <assert.h>

#include "common.h"


const GLfloat glBlack[] = { 0.0, 0.0, 0.0, 0.0 };
const GLfloat glGray25[] = { 0.25, 0.25, 0.25 };
const GLfloat glGray50[] = { 0.5, 0.5, 0.5 };
const GLfloat glWhite[] = { 1.0, 1.0, 1.0 };

const GLfloat glRed[]		= { 1.0, 0.0, 0.0 };
const GLfloat glYellow[]	= { 1.0, 1.0, 0.0 };
const GLfloat glGreen[]		= { 0.0, 1.0, 0.0 };
const GLfloat glCyan[]		= { 0.0, 1.0, 1.0 };
const GLfloat glBlue[]		= { 0.0, 0.0, 1.0 };
const GLfloat glMagenta[]	= { 1.0, 0.0, 1.0 };

const GLfloat glHoverCol[] = { 0.5, 0.5, 1.0 };

/* Disable GL_FUNC_REVERSE_SUBTRACT if it doesn't work.  This,
 * however, causes the screen to be too bright.
 */
bool gl_reverse_subtract;

/* The Allegro font after being passed through AllegroGL. */
FONT *al_font;


void algl_textout_centre(const FONT *f, const char *str,
			 const float x, const float y, const float z)
{
    int len;

    len = text_length(f, str);
    allegro_gl_printf_ex(f, x-len/2, y, z, str);
}
