/* angle.c,
 *
 * Angle format conversion routines.
 */

#include <assert.h>
#include "angle.h"


/* charize_angle:
 *
 * Compress a floating point angle (given in radians) down to a char.
 * Angle is assumed to be between -M_PI and M_PI.
 */
char charize_angle(const float angle)
{
    if (angle >= 0.0)
	return angle * 128/M_PI;
    else
	return (angle+2*M_PI) * 128/M_PI;
}


float uncharize_angle(const char angle)
{
    return angle * M_PI/128;
}
