#ifndef __included_step_h__
#define __included_step_h__

#include <stdbool.h>

/* Return flags for the stepping function. */
#define STEP_NO_COLLIDE		0x00
#define STEP_COLLIDE_LEFT	0x01
#define STEP_COLLIDE_RIGHT	0x02
#define STEP_COLLIDE_TOP	0x04
#define STEP_COLLIDE_BOTTOM	0x08
#define STEP_COLLIDE_X		(STEP_COLLIDE_LEFT|STEP_COLLIDE_RIGHT)
#define STEP_COLLIDE_Y		(STEP_COLLIDE_TOP|STEP_COLLIDE_BOTTOM)
#define STEP_COLLIDE_XY		(STEP_COLLIDE_X|STEP_COLLIDE_Y)

typedef struct {
    /* Copy position and velocity of object. */
    void (*copy)(const void *src, void *dest);

    /* Stepping (and collision detection) function. */
    int (*step)(void *p, const double dx, const double dy);
} walk_callbacks_t;

typedef struct {
    /* Fetching velocities. */
    void (*velocity)(const void *p, double *vx, double *vy);

    /* Stepping (and collision detection) function. */
    int (*step)(void *p, const int tick, const void *data);

    /* Callback after collision has taken place.  Return true if the
       particle should stop stepping. */
    bool (*collided)(void *p, const int tick, const int collisions);
} walk_time_callbacks_t;


extern int velocity_to_steps(const double vx, const double vy,
			     double *dx, double *dy);
extern bool walk(void *p, void *work, double vx, const double vy,
		 const walk_callbacks_t *func);
extern bool walk_time(void *p, const walk_time_callbacks_t *func,
		      int tick, const int end_time, const void *data);
extern bool walk_time_crude(void *p, const walk_time_callbacks_t *func,
			    int tick, const int end_time, const void *data);

#endif
