#ifndef __included_stats_meat_h__
#define __included_stats_meat_h__

#include "meat.inc"
#include "sprite.h"
#include "stats-particle.h"

typedef struct {
    int life_min, life_rand;	/* msec */
    int v_min, v_rand;		/* pixels/sec */
    double bounciness;

    struct {
	bool spew;
	enum PARTICLE_CATEGORY cat;
    } particles;
} meat_stats_t;


extern const unsigned int meat_spawn_num[NUM_MEAT_CATEGORIES];
extern const meat_stats_t meat_stats[NUM_MEAT_CLASSES];
extern const sprite_t meat_sprite[NUM_MEAT_CLASSES];

extern enum MEAT_CLASS meat_class_from_category(const enum MEAT_CATEGORY cat);

#endif
