#ifndef __included_sound_h__
#define __included_sound_h__

#include "player.inc"
#include "weapon.inc"

#define SFX_DIR		"data/sfx/"


extern bool reverse_stereo;

extern void play_explosion(const float x, const float y);
extern void explosion_sound_load(void);
extern void explosion_sound_free(void);

extern void play_player_hurt(const double dist_sq, const double dx);
extern void player_sound_load(void);
extern void player_sound_free(void);

extern void play_weapon_fire(const enum WEAPON_CLASS w, const player_id id,
			     const float x, const float y);
extern int play_missile_flight(const float x, const float y,
			       const float vx, const float vy);
extern void stop_missile_flight(const int n);
extern void weapon_sound_load(void);
extern void weapon_sound_free(void);

extern void sound_poll(void);
extern void sound_set_volume(const int volume);
extern unsigned int sound_get_volume(void);
extern void sound_start(void);
extern void sound_stop(void);
extern void sound_init(void);
extern void sound_shutdown(void);

#endif
