#ifndef __included_slist_h__
#define __included_slist_h__


/* Singly-linked list version of 'list.h'. */


typedef struct slist_head slist_head_t;

struct slist_head {
    void *next;
};

#define slist_init(L)		do { L.next = &L; } while (0)
#define slist_eq(m, n)		((void *) m == (void *) n)
#define slist_neq(m, n)		(!(slist_eq (m, n)))
#define slist_empty(L)		(slist_eq (L.next, &L))
#define slist_next(n)		(((slist_head_t *) n) -> next)

#define slist_add_at_pos(L, n)			\
do {						\
    slist_next(n) = slist_next(L);		\
    slist_next(L) = n;				\
} while (0)


#define slist_add(L, n)		slist_add_at_pos ((&L), n)

#define slist_remove(n, p)			\
do {						\
    slist_next(p) = slist_next(n);		\
    slist_next(n) = NULL;			\
} while (0)

#define slist_for_each(n, L)					\
for (n = slist_next(L); slist_neq (n, L); n = slist_next(n))

#define slist_for_each_prev(n, pv, L)				\
for (pv = (void *)L, n = slist_next(L); slist_neq (n, L);	\
     pv = n, n = slist_next(n))

#define slist_for_each_next(n, nx, L)				\
for (n = slist_next(L), nx = slist_next(n);			\
     slist_neq (n,L); n = nx, nx = slist_next(nx))

#define slist_free(L, dtor)					\
do {								\
    slist_head_t *x, *y;					\
    for (x = L.next; slist_neq (x, &L); x = y) {		\
	y = slist_next(x);					\
	dtor((void *)x);					\
    }								\
    slist_init(L);						\
} while (0)


#endif
