#ifndef __included_server_h__
#define __included_server_h__

#include <stdbool.h>
#include <nl.h>

#include "game-state.h"
#include "player.inc"
#include "robot.h"
#include "sv-internal.h"

extern int server_time;
extern enum GAME_MODE game_mode;

extern void server_announce(const char *format, ...);
extern bool server_broadcast(const NLvoid *buf, NLint nbytes);
extern void server_broadcast2(const player_id id,
			      const NLvoid *lbuf, const NLint llen,
			      const NLvoid *rbuf, const NLint rlen);
extern bool server_send(const NLsocket client,
			const NLvoid *buf, const NLint nbytes);
extern void server_feed_map(const NLsocket client, game_state_t *state);
extern void server_feed_starts(const NLsocket client);
extern void server_feed_containers(NLsocket client);
extern void server_feed_gizmos(NLsocket client);
extern void server_feed_candela(const NLsocket client);
extern void server_join_robot(robot_t *rob, client_data_t *data,
			      game_state_t *state);
extern void server_join_player(client_data_t *data, game_state_t *state);
extern void server_feed_pickup(NLsocket client);
extern bool server_maybe_new_connection(void);
extern bool server_may_add_robot(void);
extern bool server_maybe_new_robot(void);
extern void server_disconnect(client_data_t *data,
			      const enum DISCONNECT_REASON why,
			      game_state_t *state);
extern void server_incoming(game_state_t *state);
extern void server_outgoing(game_state_t *state);
extern void server_end_session(void);
extern bool server_init(const NLushort port);
extern void server_shutdown(void);

#endif
