#ifndef __included_robot_h__
#define __included_robot_h__

#include "game-state.h"
#include "player.h"

#define MAX_ROBOTS		16
#define NUM_ROBOT_NAMES		4

enum ROBOT_CLASS {
    ROBOT_GRUNT,
    ROBOT_DWARF,
    ROBOT_MISER,
};

typedef struct {
    enum ROBOT_CLASS class;

    client_id clid;
    player_t *player;
} robot_t;


extern const char *robot_name[NUM_ROBOT_NAMES];
extern robot_t robot[MAX_ROBOTS];
extern unsigned int num_robots;

extern void robot_logic(const game_state_t *state);
#ifdef DEBUG_ROBOT
extern void robot_draw(void);
#else
# define robot_draw()
#endif
extern void robot_attach(robot_t *rob, const player_id id,
			 const game_state_t *state);

#endif
