#ifndef __included_player_h__
#define __included_player_h__

#include <stdbool.h>
#include "game-state.h"
#include "list.h"
#include "packet-player.h"
#include "powerup.h"
#include "weapon.inc"

#define PLAYER_H	32
#define PLAYER_W	9
#define PLAYER_W_2	(PLAYER_W/2)
#define MAX_JUMP_FRAMES	25
#define MAX_HISTORIES	5
#define NUM_FACES	16
#define NUM_HUMAN_FACES	14
#define NUM_ROBOT_FACES	2

enum MOVEMENT_MODE {
    MOVEMENT_NORMAL,
    MOVEMENT_IN_LADDER,
    MOVEMENT_ABOVE_LADDER
};

typedef struct player {
    struct player *next;
    struct player *prev;

    player_id id;

    bool alive;
    int health;
    int next_bleed_time;

    double x, y;
    double vx, vy;
    bool mirror;		/* True when facing left */
    double angle;
    double sent_angle;
    double tracker_angle;

    enum WEAPON_CLASS weapon;
    double fire_delay;
    int frame, frame_delay;

    bool have_weapon[NUM_WEAPON_CLASSES];
    unsigned int weapon_ammo[NUM_WEAPON_CLASSES];
    int powerup_duration[NUM_POWERUP_CLASSES];

    struct {
	int server_time, tics;
	double x, y;
    } history[MAX_HISTORIES];

    enum MOVEMENT_MODE movement_mode;
    bool can_jump;
    char hold_keys;
    int jump_frame;

    int packet_size;
    int last_impy;
    int kills_this_life;
} player_t;


extern player_t *player;

extern player_t *player_touching_point(const double X1, const double Y1,
				       const game_state_t *state);
extern player_t *player_touching_box(const int X1, const int Y1,
				     const int W1, const int H1,
				     const game_state_t *state);
extern void player_hurt(player_t *p, const int damage,
			const double vx, const double vy,
			const player_id hurter, game_state_t *state);
extern void player_update(game_state_t *state);
extern void player_save_history(player_t *p,
				const struct packet_player_update *);
extern void player_predict_move(game_state_t *state);
extern void player_draw(const game_state_t *state);
extern void player_draw_avatar(const unsigned char face_num,
			       const int x, const int y);
extern player_t *player_from_id(const player_id id, const game_state_t *state);
extern player_t *player_closest(const player_t *pl, double *min_dist_sq,
				const game_state_t *state);
extern bool player_tracker_angle(const player_t *p,
				 double *dx, double *dy, double *angle,
				 const game_state_t *state);
extern void player_new_life(player_t *p);
extern player_id player_generate_unique_id(void);
extern void player_new(const struct packet_player_new *packet,
		       game_state_t *state);
extern void player_shift(const double offx, const double offy,
			 game_state_t *state);
extern void player_free(player_t *p);
extern void player_start(game_state_t *state);
extern void player_stop(game_state_t *state);
extern void player_init(void);
extern void player_shutdown(void);

#endif
