#ifndef __included_packet_player_h__
#define __included_packet_player_h__

#include <nl.h>
#include <stdbool.h>
#include "backpack.inc"
#include "player.inc"
#include "start-loc.inc"
#include "weapon.inc"

/* Flags for 'size' in player update packets: */
#define PACKET_INCLUDE_WEAPON		0x01
#define PACKET_INCLUDE_ANGLE		0x02
#define PACKET_INCLUDE_FIRING		0x04
#define PACKET_INCLUDE_AMMO		0x08
#define PACKET_INCLUDE_HEALTH		0x10
#define PACKET_INCLUDE_TRACKER		0x20
#define PACKET_INCLUDE_BLEED		0x80

#define PACKET_COMMON_INCLUDES		\
	(PACKET_INCLUDE_WEAPON|		\
	 PACKET_INCLUDE_BLEED)
#define PACKET_LOCAL_INCLUDES		\
	(PACKET_COMMON_INCLUDES|	\
	 PACKET_INCLUDE_FIRING|		\
	 PACKET_INCLUDE_AMMO|		\
	 PACKET_INCLUDE_HEALTH|		\
	 PACKET_INCLUDE_TRACKER)
#define PACKET_REMOTE_INCLUDES		\
	(PACKET_COMMON_INCLUDES|	\
	 PACKET_INCLUDE_ANGLE)

enum DISCONNECT_REASON {
    DISCONNECT_REQUEST,
    DISCONNECT_LAG,
    DISCONNECT_JERK
};

enum DEATH_REASON {
    DEATH_BY_FALL,
    DEATH_BY_SUICIDE,
    DEATH_BY_OPPONENT,
    DEATH_UNKNOWN_CAUSE
};

#define sizeof_packet_player_new_begin	(1+1)
#define sizeof_packet_player_new	(1+1+1+2+2+MAX_NAME_LEN)

struct packet_player_new {
    client_id clid;

    player_id id;
    bool alive;
    double x, y;
};

struct packet_player_attach {
    player_id id;
};

struct packet_player_update {
    int time;

    player_id id;
    float x, y;

    /* Optional: */
    int size;

    enum WEAPON_CLASS weapon;
    bool mirror;
    float angle;
    int ammo;
    int health;
    float tracker;
};

struct packet_player_respawn {
    player_id id;
    start_loc_id loc;
};

struct packet_player_die {
    int time;

    player_id id;
    enum DEATH_REASON why;
    float x, y;
    float vx, vy;

    backpack_id bp;
    player_id murderer;
};

struct packet_disconnect {
    client_id clid;
    enum DISCONNECT_REASON why;
};


extern NLint
packet_player_new_begin_encode(const int num,
			       NLbyte *buf, const NLint sz);
extern NLint
packet_player_new_begin_decode(int *num,
			       const NLbyte *buf, const NLint sz);
extern NLint
packet_player_new_encode(const struct packet_player_new *packet,
			 NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_player_new_decode(struct packet_player_new *packet,
			 const NLbyte *buf, const NLint sz, NLint count);
extern NLint packet_player_attach_encode(const struct packet_player_attach *,
					 NLbyte *buf, NLint size);
extern void packet_player_attach_decode(struct packet_player_attach *packet,
					const NLbyte *buf, const NLint size);
extern NLint packet_player_update_encode(const struct packet_player_update *,
					 const bool local,
					 NLbyte *buf, NLint size);
extern void packet_player_update_decode(struct packet_player_update *packet,
					const bool local, const bool large,
					const NLbyte *buf, const NLint size);
extern NLint packet_player_respawn_encode(const struct packet_player_respawn *,
					  NLbyte *buf, NLint size);
extern void packet_player_respawn_decode(struct packet_player_respawn *packet,
					 const NLbyte *buf, const NLint size);
extern NLint packet_player_die_encode(const struct packet_player_die *packet,
				      NLbyte *buf, NLint size);
extern void packet_player_die_decode(struct packet_player_die *packet,
				     const NLbyte *buf, const NLint size);
extern NLint packet_disconnect_encode(const struct packet_disconnect *packet,
				      NLbyte *buf, NLint size);
extern void packet_disconnect_decode(struct packet_disconnect *packet,
				     const NLbyte *buf, const NLint size);

#endif
