#ifndef __included_packet_input_h__
#define __included_packet_input_h__

#include <nl.h>
#include "player.inc"
#include "score.h"
#include "sv-internal.h"
#include "weapon.inc"

struct packet_input_info {
    char name[MAX_NAME_LEN];
    enum CLIENT_TYPE type;
    unsigned char face;

    /* Server to client packets also include: */
    client_id clid;
    score_t sc;
};

struct packet_input_move {
    player_id id;
    char impy;
    bool mirror;
    float angle;

    /* Wield packets also include: */
    enum WEAPON_CLASS weapon;
};


extern NLint packet_input_info_encode(const struct packet_input_info *packet,
				      const char command,
				      NLbyte *buf, NLint buf_size);
extern void packet_input_info_decode(struct packet_input_info *packet,
				     const char command,
				     const NLbyte *buf, const NLint buf_size);
extern NLint packet_input_move_encode(const struct packet_input_move *packet,
				      const char command,
				      NLbyte *buf, NLint buf_size);
extern void packet_input_move_decode(struct packet_input_move *packet,
				     const char command,
				     const NLbyte *buf, const NLint buf_size);
extern NLint packet_input_chat_encode(const NLbyte *string,
				      NLbyte *buf, NLint buf_size);
extern void packet_input_chat_decode(NLbyte *string,
				     const NLbyte *buf, const NLint buf_size);

#endif
