#ifndef __included_packet_gizmo_h__
#define __included_packet_gizmo_h__

#include <nl.h>
#include "gizmo.inc"

#define sizeof_packet_gizmo_new_begin	(1+1)
#define sizeof_packet_gizmo_new		(2+1+2+2)

struct packet_gizmo_new {
    gizmo_id id;
    enum GIZMO_CLASS class;
    double x, y;
};


extern NLint
packet_gizmo_new_begin_encode(const int num,
			      NLbyte *buf, const NLint sz);
extern NLint
packet_gizmo_new_begin_decode(int *num,
			      const NLbyte *buf, const NLint sz);
extern NLint
packet_gizmo_new_encode(const struct packet_gizmo_new *packet,
			NLbyte *buf, const NLint sz, NLint count);
extern NLint
packet_gizmo_new_decode(struct packet_gizmo_new *packet,
			const NLbyte *buf, const NLint sz, NLint count);


/* Map editor only. */
struct packet_gizmo_mov {
    gizmo_id id;
    double x, y;
};

struct packet_gizmo_del {
    gizmo_id id;
};


extern NLint packet_gizmo_mov_encode(const struct packet_gizmo_mov *packet,
				     NLbyte *buf, NLint size);
extern void packet_gizmo_mov_decode(struct packet_gizmo_mov *packet,
				    const NLbyte *buf, const NLint size);
extern NLint packet_gizmo_del_encode(const struct packet_gizmo_del *packet,
				     NLbyte *buf, NLint size);
extern void packet_gizmo_del_decode(struct packet_gizmo_del *packet,
				    const NLbyte *buf, const NLint size);

#endif
