#ifndef __included_packet_editor_h__
#define __included_packet_editor_h__

#include <nl.h>
#include "map.h"
#include "packet-candela.h"
#include "packet-container.h"
#include "packet-gizmo.h"
#include "packet-pickup.h"
#include "packet-starts.h"

#define NUM_EDITOR_MODES	7

/* These are sent across as editor mode/actions for convenience.  They
   aren't really, so don't put them in the enum. */
#define EDITOR_ENABLE		126
#define EDITOR_DISABLE		127

enum EDITOR_MODE {
    EDIT_TILES,
    EDIT_CONTAINERS,
    EDIT_GIZMOS,
    EDIT_PICKUPS,
    EDIT_STARTS,
    EDIT_CANDELA,
    EDIT_REGIONS
};

enum EDITOR_ACTION {
    EDIT_ADD,
    EDIT_MOVE,
    EDIT_DELETE
};

enum EDITOR_MODE_ACTION {
    EDIT_TILE_SET,
    EDIT_CONTAINER_ADD,
    EDIT_CONTAINER_MOVE,
    EDIT_CONTAINER_DELETE,
    EDIT_GIZMO_ADD,
    EDIT_GIZMO_MOVE,
    EDIT_GIZMO_DELETE,
    EDIT_PICKUP_ADD,
    EDIT_PICKUP_MOVE,
    EDIT_PICKUP_DELETE,
    EDIT_START_ADD,
    EDIT_START_DELETE,
    EDIT_CANDELA_ADD,
    EDIT_CANDELA_DELETE,
    EDIT_REGION_SET,
    EDIT_PLAYER_TELEPORT,
    EDIT_UNKNOWN
};

struct packet_tile_set {
    unsigned int tile;
    unsigned char brush_size;
    int x, y;
};

struct packet_region_set {
    unsigned int region;
    unsigned char brush_size;
    int x, y;
};

struct packet_player_tp {
    player_id id;
    int x, y;
};

struct packet_editor {
    enum EDITOR_MODE editor_mode;
    enum EDITOR_ACTION action;
    enum EDITOR_MODE_ACTION mode;

    union {
	struct packet_tile_set tile;
	struct packet_container_new container_new;
	struct packet_container_mov container_mov;
	struct packet_container_del container_del;
	struct packet_gizmo_new gizmo_new;
	struct packet_gizmo_mov gizmo_mov;
	struct packet_gizmo_del gizmo_del;
	struct packet_pickup_new pickup_new;
	struct packet_pickup_mov pickup_mov;
	struct packet_pickup_del pickup_del;
	struct packet_start_loc start_new;
	struct packet_start_del start_del;
	struct packet_candela_new candela_new;
	struct packet_candela_del candela_del;
	struct packet_region_set region;
	struct packet_player_tp player_tp;
    } new;
};


extern enum EDITOR_MODE_ACTION
to_mode_action(const enum EDITOR_MODE mode, const enum EDITOR_ACTION action);
extern NLint packet_editor_encode(const struct packet_editor *packet,
				  NLbyte *buf, NLint size);
extern void packet_editor_decode(struct packet_editor *packet,
				 const NLbyte *buf, const NLint size);

#endif
