#ifndef __included_meat_h__
#define __included_meat_h__

#include "meat.inc"

typedef struct meat {
    struct meat *next;
    struct meat *prev;

    enum MEAT_CLASS class;

    /* Spawn state. */
    int _spawn_time;
    float _spawn_x, _spawn_y;
    float _spawn_vx, _spawn_vy;

    /* Current state. */
    int life, time;
    float x, y;
    float spin, delta_spin;		/* degrees */

    int next_blood_time;
} meat_t;


extern list_head_t meat_list;

extern void meat_update(void);
extern void meat_draw(void);
extern void meat_new(const enum MEAT_CATEGORY cat,
		     const float x, const float y,
		     const float vx, const float vy, const int tick);
extern void meat_start(void);
extern void meat_stop(void);
extern void meat_init(void);
extern void meat_shutdown(void);

#endif
