#ifndef __included_game_state_h__
#define __included_game_state_h__

#include <stdbool.h>

#include "list.h"

#define NUM_GAME_MODES	2

enum GAME_MODE {
    GAME_MODE_CLASSIC,
    GAME_MODE_SILHOUETTES
};

typedef struct {
    bool as_server;

    enum {
	SERVER_QUIT,
	SERVER_IN_LOBBY,
	SERVER_IN_GAME
    } context;
    enum GAME_MODE game_mode;
    bool editor_enabled;

    char next_map[128];
    enum GAME_MODE next_game_mode;

    list_head_t backpack_list;
    list_head_t bullet_list;
    list_head_t explosion_list;
    list_head_t player_list;
} game_state_t;


extern const char *game_mode_str_from_mode(const enum GAME_MODE mode);
extern void game_state_init(game_state_t *state, const enum GAME_MODE mode,
			    const bool as_server);

#endif
