#ifndef __included_explosion_h__
#define __included_explosion_h__

#include "game-state.h"
#include "list.h"
#include "lux.h"
#include "packet-explosion.h"
#include "player.inc"

#define MAX_EXPLOSION_HURTEES		8

typedef struct explosion {
    struct explosion *next;
    struct explosion *prev;

    explosion_id id;
    player_id parent;
    double damage;
    double modifier;		/* Berserker or handycap. */

    /* Spawn state. */
    int _spawn_time;
    double _spawn_x, _spawn_y;
    double _spawn_r, _spawn_max_r;

    /* Current state. */
    int time;
    double r;

    lux_t *lux;

    /* This is lazy.  Don't hurt players twice. */
    player_id hurtee[MAX_EXPLOSION_HURTEES];
} explosion_t;


extern list_head_t explosion_delete_list;

extern void explosion_update(game_state_t *state);
extern explosion_t *explosion_from_id(const explosion_id id,
				      game_state_t *state);
extern explosion_id explosion_generate_unique_id(void);
extern void explosion_new(const struct packet_explosion_new *packet,
			  const player_id parent, game_state_t *state);
extern void explosion_free(explosion_t *e);
extern void explosion_start(game_state_t *state);
extern void explosion_stop(game_state_t *state);
extern void explosion_init(void);
extern void explosion_shutdown(void);

#endif
