#ifndef __included_coro_h__
#define __included_coro_h__

#include <stdbool.h>

#ifdef __unix__

#include <pth.h>

#define coro_init()	coro_pth_init()
#define coro_self()	coro_pth_self()
#define coro_spawn(a,b)	coro_pth_spawn(a,b)
#define coro_yield(a)	coro_pth_yield(a)
#define coro_join(a)	coro_pth_join(a)
#define __stdcall	/* Nothing */

typedef pth_t coro_t;

extern bool coro_pth_init(void);
extern pth_t coro_pth_self(void);
extern pth_t coro_pth_spawn(void __stdcall (*entry)(void *), void *arg);
extern bool coro_pth_yield(pth_t tid);
extern int coro_pth_join(pth_t tid);

#else  /* !__unix__ */

#include <windows.h>

#define coro_init()	coro_fibre_init()
#define coro_self()	coro_fibre_self()
#define coro_spawn(a,b)	coro_fibre_spawn(a,b)
#define coro_yield(a)	coro_fibre_yield(a)
#define coro_join(a)	coro_fibre_join(a)

typedef LPVOID coro_t;

extern bool coro_fibre_init(void);
extern LPVOID coro_fibre_self(void);
extern LPVOID coro_fibre_spawn(void __stdcall (*entry)(LPVOID), LPVOID arg);
extern bool coro_fibre_yield(LPVOID fiber);
extern int coro_fibre_join(LPVOID fiber);

#endif /* !__unix__ */

#endif
