/* Generated by bindgen.lua on Sat Dec 28 11:52:15 2002.  Do not edit.  */

static int bind_store_load(lua_State *L)
{
	const char * filename;
	const char * prefix;
	int ret;
	if (!lua_checkargs(L, "ss")) goto badargs;
	filename = lua_tostring(L, 1);
	prefix = lua_tostring(L, 2);
	ret = !store_load_ex(filename, prefix, load_extended_datafile);
	if (ret) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to store_load\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_tiles_load(lua_State *L)
{
	const char * filename;
	const char * prefix;
	int ret;
	if (!lua_checkargs(L, "ss")) goto badargs;
	filename = lua_tostring(L, 1);
	prefix = lua_tostring(L, 2);
	ret = tiles_load(filename, prefix);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to tiles_load\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_lights_load(lua_State *L)
{
	const char * filename;
	const char * prefix;
	int ret;
	if (!lua_checkargs(L, "ss")) goto badargs;
	filename = lua_tostring(L, 1);
	prefix = lua_tostring(L, 2);
	ret = lights_load(filename, prefix);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to lights_load\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_objtype_register(lua_State *L)
{
	const char * type;
	const char * name;
	const char * icon;
	lua_ref_t func;
	int ret;
	if (!lua_checkargs(L, "[sN]ss[fN-]")) goto badargs;
	type = lua_isnil(L, 1) ? 0 : lua_tostring(L, 1);
	name = lua_tostring(L, 2);
	icon = lua_tostring(L, 3);
	func = (lua_isnoneornil(L, 4) ? LUA_NOREF : lua_ref(L, 4));
	ret = objtypes_register(type, name, icon, func);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to objtype_register\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_explosion_type_register(lua_State *L)
{
	const char * name;
	const char * first_frame;
	int nframes;
	int tics;
	const char * light;
	const char * sound;
	int ret;
	if (!lua_checkargs(L, "ssnn[sN-][sN-]")) goto badargs;
	name = lua_tostring(L, 1);
	first_frame = lua_tostring(L, 2);
	nframes = lua_tonumber(L, 3);
	tics = lua_tonumber(L, 4);
	light = (lua_isnoneornil(L, 5) ? 0 : lua_tostring(L, 5));
	sound = (lua_isnoneornil(L, 6) ? 0 : lua_tostring(L, 6)); 
	ret = explosion_type_register(name, first_frame, nframes, tics, light, sound);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to explosion_type_register\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_new_object_collision_tag(lua_State *L)
{
	objtag_t ret;
	if (!lua_checkargs(L, "")) goto badargs;
	ret = new_object_collision_tag();
	lua_pushnumber(L, ret); return 1;
badargs:
	printf("bad args to new_object_collision_tag\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_stale(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_set_stale(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_stale\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_hide(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_hide(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_hide\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_show(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_show(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_show\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_highlighted(lua_State *L)
{
	object_t * obj;
	int yes_or_no;
	if (!lua_checkargs(L, "ub")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	yes_or_no = lua_toboolean(L, 2);
	object_set_highlighted(obj, yes_or_no);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_highlighted\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind__internal_object_moving_horizontally(lua_State *L)
{
	object_t * obj;
	int ret;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	ret = object_moving_horizontally(obj);
	if (!ret) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to _internal_object_moving_horizontally\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_collision_is_player(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_set_collision_is_player(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_collision_is_player\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_collision_is_projectile(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_set_collision_is_projectile(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_collision_is_projectile\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_collision_is_ladder(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_set_collision_is_ladder(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_collision_is_ladder\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_collision_flags(lua_State *L)
{
	object_t * obj;
	const char * flags;
	if (!lua_checkargs(L, "us")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	flags = lua_tostring(L, 2);
	object_set_collision_flags_string(obj, flags);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_collision_flags\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_collision_tag(lua_State *L)
{
	object_t * obj;
	objtag_t tag;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	tag = lua_tonumber(L, 2);
	object_set_collision_tag(obj, tag);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_collision_tag\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_add_creation_field(lua_State *L)
{
	object_t * obj;
	const char * name;
	if (!lua_checkargs(L, "us")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	name = lua_tostring(L, 2);
	object_add_creation_field(obj, name);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_add_creation_field\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_update_hook(lua_State *L)
{
	object_t * obj;
	int msecs;
	lua_ref_t method;
	if (!lua_checkargs(L, "unf")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	msecs = lua_tonumber(L, 2);
	method = lua_ref(L, 3);
	object_set_update_hook(obj, msecs, method);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_update_hook\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_update_hook(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_remove_update_hook(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_update_hook\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_add_layer(lua_State *L)
{
	object_t * obj;
	const char * image;
	int xoffset;
	int yoffset;
	int layerid;
	if (!lua_checkargs(L, "usnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	image = lua_tostring(L, 2);
	xoffset = lua_tonumber(L, 3);
	yoffset = lua_tonumber(L, 4);
	layerid = object_add_layer(obj, image, xoffset, yoffset);
	lua_pushnumber(L, layerid); return 1;
badargs:
	printf("bad args to object_add_layer\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_replace_layer(lua_State *L)
{
	object_t * obj;
	int layerid;
	const char * image;
	int xoffset;
	int yoffset;
	int ret;
	if (!lua_checkargs(L, "unsnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	layerid = lua_tonumber(L, 2);
	image = lua_tostring(L, 3);
	xoffset = lua_tonumber(L, 4);
	yoffset = lua_tonumber(L, 5);
	ret = object_replace_layer(obj, layerid, image, xoffset, yoffset);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_replace_layer\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_move_layer(lua_State *L)
{
	object_t * obj;
	int layerid;
	int xoffset;
	int yoffset;
	int ret;
	if (!lua_checkargs(L, "unnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	layerid = lua_tonumber(L, 2);
	xoffset = lua_tonumber(L, 3);
	yoffset = lua_tonumber(L, 4);
	ret = object_move_layer(obj, layerid, xoffset, yoffset);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_move_layer\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_hflip_layer(lua_State *L)
{
	object_t * obj;
	int layerid;
	int hflip;
	int ret;
	if (!lua_checkargs(L, "unb")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	layerid = lua_tonumber(L, 2);
	hflip = lua_toboolean(L, 3);
	ret = object_hflip_layer(obj, layerid, hflip);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_hflip_layer\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_rotate_layer(lua_State *L)
{
	object_t * obj;
	int layerid;
	int angle;
	int ret;
	if (!lua_checkargs(L, "unn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	layerid = lua_tonumber(L, 2);
	angle = lua_tonumber(L, 3);
	ret = object_rotate_layer(obj, layerid, angle);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_rotate_layer\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_layer(lua_State *L)
{
	object_t * obj;
	int layerid;
	int ret;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	layerid = lua_tonumber(L, 2);
	ret = object_remove_layer(obj, layerid);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_layer\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_all_layers(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_remove_all_layers(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_all_layers\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_add_light(lua_State *L)
{
	object_t * obj;
	const char * image;
	int xoffset;
	int yoffset;
	int lightid;
	if (!lua_checkargs(L, "usnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	image = lua_tostring(L, 2);
	xoffset = lua_tonumber(L, 3);
	yoffset = lua_tonumber(L, 4);
	lightid = object_add_light(obj, image, xoffset, yoffset);
	lua_pushnumber(L, lightid); return 1;
badargs:
	printf("bad args to object_add_light\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_replace_light(lua_State *L)
{
	object_t * obj;
	int lightid;
	const char * image;
	int xoffset;
	int yoffset;
	int ret;
	if (!lua_checkargs(L, "unsnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	lightid = lua_tonumber(L, 2);
	image = lua_tostring(L, 3);
	xoffset = lua_tonumber(L, 4);
	yoffset = lua_tonumber(L, 5);
	ret = object_replace_light(obj, lightid, image, xoffset, yoffset);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_replace_light\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_move_light(lua_State *L)
{
	object_t * obj;
	int lightid;
	int xoffset;
	int yoffset;
	int ret;
	if (!lua_checkargs(L, "unnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	lightid = lua_tonumber(L, 2);
	xoffset = lua_tonumber(L, 3);
	yoffset = lua_tonumber(L, 4);
	ret = object_move_light(obj, lightid, xoffset, yoffset);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_move_light\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_light(lua_State *L)
{
	object_t * obj;
	int lightid;
	int ret;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	lightid = lua_tonumber(L, 2);
	ret = object_remove_light(obj, lightid);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_light\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_all_lights(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_remove_all_lights(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_all_lights\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_mask(lua_State *L)
{
	object_t * obj;
	int masknumber;
	const char * mask;
	int xoffset;
	int yoffset;
	int ret;
	if (!lua_checkargs(L, "unsnn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	masknumber = lua_tonumber(L, 2);
	mask = lua_tostring(L, 3);
	xoffset = lua_tonumber(L, 4);
	yoffset = lua_tonumber(L, 5);
	ret = object_set_mask(obj, masknumber, mask, xoffset, yoffset);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_mask\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_set_masks_centre(lua_State *L)
{
	object_t * obj;
	int xoffset;
	int yoffset;
	if (!lua_checkargs(L, "unn")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	xoffset = lua_tonumber(L, 2);
	yoffset = lua_tonumber(L, 3);
	object_set_masks_centre(obj, xoffset, yoffset);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_set_masks_centre\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_mask(lua_State *L)
{
	object_t * obj;
	int masknumber;
	int ret;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	masknumber = lua_tonumber(L, 2);
	ret = object_remove_mask(obj, masknumber);
	if (ret < 0) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_mask\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_object_remove_all_masks(lua_State *L)
{
	object_t * obj;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	object_remove_all_masks(obj);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to object_remove_all_masks\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_object(lua_State *L)
{
	const char * typename;
	float x;
	float y;
	object_t * obj;
	if (!lua_checkargs(L, "snn")) goto badargs;
	typename = lua_tostring(L, 1);
	x = lua_tonumber(L, 2);
	y = lua_tonumber(L, 3);
	obj = svgame_spawn_object(typename, x, y);
	if (!obj) goto error;
	lua_pushobject(L, obj); return 1;
badargs:
	printf("bad args to spawn_object\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_projectile(lua_State *L)
{
	const char * typename;
	object_t * owner;
	float speed;
	float delta_angle;
	object_t * obj;
	if (!lua_checkargs(L, "sun[nN-]")) goto badargs;
	typename = lua_tostring(L, 1);
	owner = lua_toobject(L, 2);
	if (!owner) goto badargs;
	speed = lua_tonumber(L, 3);
	delta_angle = (lua_isnoneornil(L, 4) ? 0. : lua_tonumber(L, 4));
	obj = svgame_spawn_projectile(typename, owner, speed, delta_angle);
	if (!obj) goto error;
	lua_pushobject(L, obj); return 1;
badargs:
	printf("bad args to spawn_projectile\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_projectile_raw(lua_State *L)
{
	const char * typename;
	objid_t ownerid;
	float x;
	float y;
	float angle;
	float speed;
	object_t * obj;
	if (!lua_checkargs(L, "snnnnn")) goto badargs;
	typename = lua_tostring(L, 1);
	ownerid = lua_tonumber(L, 2);
	x = lua_tonumber(L, 3);
	y = lua_tonumber(L, 4);
	angle = lua_tonumber(L, 5);
	speed = lua_tonumber(L, 6);
	obj = svgame_spawn_projectile_raw(typename, ownerid, x, y, angle, speed);
	if (!obj) goto error;
	lua_pushobject(L, obj); return 1;
badargs:
	printf("bad args to spawn_projectile_raw\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_blood_on_clients(lua_State *L)
{
	float x;
	float y;
	int nparticles;
	float spread;
	if (!lua_checkargs(L, "nnnn")) goto badargs;
	x = lua_tonumber(L, 1);
	y = lua_tonumber(L, 2);
	nparticles = lua_tonumber(L, 3);
	spread = lua_tonumber(L, 4);
	svgame_spawn_blood(x, y, nparticles, spread);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_blood_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_sparks_on_clients(lua_State *L)
{
	float x;
	float y;
	int nparticles;
	float spread;
	if (!lua_checkargs(L, "nnnn")) goto badargs;
	x = lua_tonumber(L, 1);
	y = lua_tonumber(L, 2);
	nparticles = lua_tonumber(L, 3);
	spread = lua_tonumber(L, 4);
	svgame_spawn_sparks(x, y, nparticles, spread);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_sparks_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_respawn_particles_on_clients(lua_State *L)
{
	float x;
	float y;
	int nparticles;
	float spread;
	if (!lua_checkargs(L, "nnnn")) goto badargs;
	x = lua_tonumber(L, 1);
	y = lua_tonumber(L, 2);
	nparticles = lua_tonumber(L, 3);
	spread = lua_tonumber(L, 4);
	svgame_spawn_respawn_particles(x, y, nparticles, spread);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_respawn_particles_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_blod_on_clients(lua_State *L)
{
	float x;
	float y;
	int nparticles;
	if (!lua_checkargs(L, "nnn")) goto badargs;
	x = lua_tonumber(L, 1);
	y = lua_tonumber(L, 2);
	nparticles = lua_tonumber(L, 3);
	svgame_spawn_blod(x, y, nparticles);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_blod_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_explosion_on_clients(lua_State *L)
{
	const char * name;
	float x;
	float y;
	if (!lua_checkargs(L, "snn")) goto badargs;
	name = lua_tostring(L, 1);
	x = lua_tonumber(L, 2);
	y = lua_tonumber(L, 3);
	svgame_spawn_explosion(name, x, y);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_explosion_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_blast(lua_State *L)
{
	float x;
	float y;
	float radius;
	int damage;
	int ownerid;
	if (!lua_checkargs(L, "nnnnn")) goto badargs;
	x = lua_tonumber(L, 1);
	y = lua_tonumber(L, 2);
	radius = lua_tonumber(L, 3);
	damage = lua_tonumber(L, 4);
	ownerid = lua_tonumber(L, 5);
	svgame_spawn_blast(x, y, radius, damage, ownerid);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_blast\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_call_method_on_clients(lua_State *L)
{
	object_t * obj;
	const char * method;
	const char * arg;
	if (!lua_checkargs(L, "us[sN-]")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	method = lua_tostring(L, 2);
	arg = (lua_isnoneornil(L, 3) ? "" : lua_tostring(L, 3));
	svgame_call_method_on_clients(obj, method, arg);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to call_method_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind__internal_would_collide_with_player_if_unhidden(lua_State *L)
{
	object_t * obj;
	int ret;
	if (!lua_checkargs(L, "u")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	ret = svgame_object_would_collide_with_player_if_unhidden(obj);
	if (!ret) goto error;
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to _internal_would_collide_with_player_if_unhidden\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind__internal_tell_health(lua_State *L)
{
	object_t * obj;
	int health;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	health = lua_tonumber(L, 2);
	svgame_tell_health(obj, health);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to _internal_tell_health\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind__internal_tell_armour(lua_State *L)
{
	object_t * obj;
	int armour;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	armour = lua_tonumber(L, 2);
	svgame_tell_armour(obj, armour);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to _internal_tell_armour\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind__internal_tell_ammo(lua_State *L)
{
	object_t * obj;
	int ammo;
	if (!lua_checkargs(L, "un")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	ammo = lua_tonumber(L, 2);
	svgame_tell_ammo(obj, ammo);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to _internal_tell_ammo\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_set_score(lua_State *L)
{
	int clientid;
	const char * score;
	if (!lua_checkargs(L, "ns")) goto badargs;
	clientid = lua_tonumber(L, 1);
	score = lua_tostring(L, 2);
	svgame_set_score(clientid, score);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to set_score\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_play_sound_on_clients(lua_State *L)
{
	object_t * obj;
	const char * sample;
	if (!lua_checkargs(L, "us")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	sample = lua_tostring(L, 2);
	svgame_play_sound_on_clients(obj, sample);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to play_sound_on_clients\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_get_client_name(lua_State *L)
{
	int clientid;
	const char * ret;
	if (!lua_checkargs(L, "n")) goto badargs;
	clientid = lua_tonumber(L, 1);
	ret = svgame_get_client_name(clientid);
	if (!ret) goto error;
	lua_pushstring(L, ret); return 1;
badargs:
	printf("bad args to get_client_name\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_broadcast_text_message(lua_State *L)
{
	const char * message;
	if (!lua_checkargs(L, "s")) goto badargs;
	message = lua_tostring(L, 1);
	svgame_broadcast_text_message(message);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to broadcast_text_message\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_send_text_message(lua_State *L)
{
	int clientid;
	const char * message;
	if (!lua_checkargs(L, "ns")) goto badargs;
	clientid = lua_tonumber(L, 1);
	message = lua_tostring(L, 2);
	svgame_send_text_message(clientid, message);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to send_text_message\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_spawn_explosion(lua_State *L)
{
	const char * name;
	float x;
	float y;
	if (!lua_checkargs(L, "snn")) goto badargs;
	name = lua_tostring(L, 1);
	x = lua_tonumber(L, 2);
	y = lua_tonumber(L, 3);
	client_spawn_explosion(name, x, y);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to spawn_explosion\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind_play_sound(lua_State *L)
{
	object_t * obj;
	const char * sample;
	if (!lua_checkargs(L, "us")) goto badargs;
	obj = lua_toobject(L, 1);
	if (!obj) goto badargs;
	sample = lua_tostring(L, 2);
	client_play_sound(obj, sample);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to play_sound\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

static int bind__internal_set_camera(lua_State *L)
{
	int pushable;
	int max_dist;
	if (!lua_checkargs(L, "bn")) goto badargs;
	pushable = lua_toboolean(L, 1);
	max_dist = lua_tonumber(L, 2);
	client_set_camera(pushable, max_dist);
	lua_pushboolean(L, 1); return 1;
badargs:
	printf("bad args to _internal_set_camera\n");
	goto error; /* shut up the compiler about unused labels */
error:
	lua_pushboolean(L, 0); return 1;
}

#define DO_REGISTRATION_INIT(L)  \
	lua_register(L, "store_load", bind_store_load); \
	lua_register(L, "tiles_load", bind_tiles_load); \
	lua_register(L, "lights_load", bind_lights_load); \
	lua_register(L, "objtype_register", bind_objtype_register); \
	lua_register(L, "explosion_type_register", bind_explosion_type_register); \
	lua_register(L, "new_object_collision_tag", bind_new_object_collision_tag);

#define DO_UNREGISTRATION_INIT(L)  \
	lua_pushnil(L); lua_setglobal(L, "store_load"); \
	lua_pushnil(L); lua_setglobal(L, "tiles_load"); \
	lua_pushnil(L); lua_setglobal(L, "lights_load"); \
	lua_pushnil(L); lua_setglobal(L, "objtype_register"); \
	lua_pushnil(L); lua_setglobal(L, "explosion_type_register"); \
	lua_pushnil(L); lua_setglobal(L, "new_object_collision_tag");

#define DO_REGISTRATION_BOTH(L)  \
	lua_register(L, "object_set_update_hook", bind_object_set_update_hook); \
	lua_register(L, "object_remove_update_hook", bind_object_remove_update_hook);

#define DO_REGISTRATION_SERVER(L)  \
	lua_register(L, "object_set_stale", bind_object_set_stale); \
	lua_register(L, "object_hide", bind_object_hide); \
	lua_register(L, "object_show", bind_object_show); \
	lua_register(L, "object_set_collision_is_player", bind_object_set_collision_is_player); \
	lua_register(L, "object_set_collision_is_projectile", bind_object_set_collision_is_projectile); \
	lua_register(L, "object_set_collision_is_ladder", bind_object_set_collision_is_ladder); \
	lua_register(L, "object_set_collision_flags", bind_object_set_collision_flags); \
	lua_register(L, "object_set_collision_tag", bind_object_set_collision_tag); \
	lua_register(L, "object_add_creation_field", bind_object_add_creation_field); \
	lua_register(L, "object_set_mask", bind_object_set_mask); \
	lua_register(L, "object_set_masks_centre", bind_object_set_masks_centre); \
	lua_register(L, "object_remove_mask", bind_object_remove_mask); \
	lua_register(L, "object_remove_all_masks", bind_object_remove_all_masks); \
	lua_register(L, "spawn_object", bind_spawn_object); \
	lua_register(L, "spawn_projectile", bind_spawn_projectile); \
	lua_register(L, "spawn_projectile_raw", bind_spawn_projectile_raw); \
	lua_register(L, "spawn_blood_on_clients", bind_spawn_blood_on_clients); \
	lua_register(L, "spawn_sparks_on_clients", bind_spawn_sparks_on_clients); \
	lua_register(L, "spawn_respawn_particles_on_clients", bind_spawn_respawn_particles_on_clients); \
	lua_register(L, "spawn_blod_on_clients", bind_spawn_blod_on_clients); \
	lua_register(L, "spawn_explosion_on_clients", bind_spawn_explosion_on_clients); \
	lua_register(L, "spawn_blast", bind_spawn_blast); \
	lua_register(L, "call_method_on_clients", bind_call_method_on_clients); \
	lua_register(L, "_internal_would_collide_with_player_if_unhidden", bind__internal_would_collide_with_player_if_unhidden); \
	lua_register(L, "_internal_tell_health", bind__internal_tell_health); \
	lua_register(L, "_internal_tell_armour", bind__internal_tell_armour); \
	lua_register(L, "_internal_tell_ammo", bind__internal_tell_ammo); \
	lua_register(L, "set_score", bind_set_score); \
	lua_register(L, "play_sound_on_clients", bind_play_sound_on_clients); \
	lua_register(L, "get_client_name", bind_get_client_name); \
	lua_register(L, "broadcast_text_message", bind_broadcast_text_message); \
	lua_register(L, "send_text_message", bind_send_text_message);

#define DO_REGISTRATION_CLIENT(L)  \
	lua_register(L, "object_set_highlighted", bind_object_set_highlighted); \
	lua_register(L, "_internal_object_moving_horizontally", bind__internal_object_moving_horizontally); \
	lua_register(L, "object_add_layer", bind_object_add_layer); \
	lua_register(L, "object_replace_layer", bind_object_replace_layer); \
	lua_register(L, "object_move_layer", bind_object_move_layer); \
	lua_register(L, "object_hflip_layer", bind_object_hflip_layer); \
	lua_register(L, "object_rotate_layer", bind_object_rotate_layer); \
	lua_register(L, "object_remove_layer", bind_object_remove_layer); \
	lua_register(L, "object_remove_all_layers", bind_object_remove_all_layers); \
	lua_register(L, "object_add_light", bind_object_add_light); \
	lua_register(L, "object_replace_light", bind_object_replace_light); \
	lua_register(L, "object_move_light", bind_object_move_light); \
	lua_register(L, "object_remove_light", bind_object_remove_light); \
	lua_register(L, "object_remove_all_lights", bind_object_remove_all_lights); \
	lua_register(L, "spawn_explosion", bind_spawn_explosion); \
	lua_register(L, "play_sound", bind_play_sound); \
	lua_register(L, "_internal_set_camera", bind__internal_set_camera);
