@echo off
if [%1] == [djgpp]   goto djgpp
if [%1] == [mingw]   goto mingw
if [%1] == [msvc]    goto msvc
if [%1] == [unix]    goto unix

if [%1] == [help]    goto help
if [%1] == [--help]  goto help
if [%1] == [-?]      goto help
if [%1] == []        goto help

goto help

:djgpp

set DUH_COMPILER=DOS (DJGPP)
set DUH_MAKEFILE=makefile.dj
goto fix

:mingw

set DUH_COMPILER=Windows (MinGW)
set DUH_MAKEFILE=makefile.mgw
goto fix

:msvc

set DUH_COMPILER=Windows (MSVC)
set DUH_MAKEFILE=makefile.vc
goto fix


:help

echo.
echo Usage: fix platform
echo.
echo Where platform is djgpp, mingw or msvc
echo.
goto end

:fix

echo Configuring DUMB for %DUH_COMPILER%...

echo # generated by fix.bat > makefile
echo include make/%DUH_MAKEFILE% >> makefile


:done

set DUH_COMPILER=
set DUH_MAKEFILE=

rem echo Done! Now run makeall or makecore to start the compilation.

:end


