#include "main.h"

#define WIDTH               19
#define HEIGHT              18
#define EXTRA               40
#define MINE                10

int BASEX           = 0;
int BASEY           = 0;
int currentWidth    = 9;
int currentHeight   = 9;
int currentTraps    = 10;
int d_fg_color      = 0;
int d_bg_color      = 0;
int d_mg_color      = 0;
int d_t1_color      = 0;
int d_t2_color      = 0;
int total           = 0;

Map *create_map( int _width, int _height, int _traps )
{
    Map *map = new Map;
    map->cover = NULL;
    map->data = NULL;

    return resetMap( map, _width, _height, _traps );
}

Map *resetMap( Map *map, int _width, int _height, int _traps )
{
    dead = false;
    started = false;
    cool = false;
    timer = 0;

    if ( map != NULL )
    {
        if ( map->data != NULL )
        {
            delete []map->data;
        }

        if ( map->cover != NULL )
        {
            delete []map->cover;
        }

        map->width = currentWidth = _width;
        map->height = currentHeight = _height;
        map->traps = currentTraps = _traps;
        total = map->width * map->height;

        map->data = new int[ total ];
        map->cover = new int[ total ];

#ifndef ALLEGRO_WINDOWS
        BASEX = ( SCREEN_W - WIDTH * map->width ) / 2;
        BASEY = ( SCREEN_H - HEIGHT * map->height - EXTRA ) / 2;
#endif
        for ( int i = 0; i < total; i++ )
        {   
            map->data[ i ] = 0;
            map->cover[ i ] = 1;
        }

        for ( int i = 0; i < map->traps; i++ )
        {
            int p;

            do
            {
                p = rand() % total;
            } while ( map->data[ p ] != 0 );

            map->data[ p ] = MINE;
        }

        for ( int i = 0; i < map->width; i++ )
        {
            for ( int j = 0; j < map->height; j++ )
            {
                if ( get( map, i, j ) == 0 )
                {
                    put( map, i, j , isNextTo( map, i, j ) );
                }
            }
        }
    }

    return map;
}

void destroy_map( Map *map )
{
    if ( map != NULL )
    {
        if ( map->data != NULL )
        {
            delete []map->data;
        }

        if ( map->cover != NULL )
        {
            delete []map->cover;
        }

        delete map;
    }
}

int get( Map *map, int x, int y )
{
    if ( x < 0 || y < 0 || x >= map->width || y >= map->height ) return 0;

    return map->data[ x + y * map->width ];
}

void put( Map *map, int x, int y, int p )
{
    map->data[ x + y * map->width ] = p;
}

void draw_map( BITMAP *bitmap, Map *map )
{
    int color, x, y, p;

    clear_to_color( bitmap, 0);

    rectfill( bitmap, BASEX, BASEY, BASEX - 1 + WIDTH * map->width, BASEY + EXTRA - 1 + HEIGHT * map->height, makecol( 224, 224, 255 ) );
    rect( bitmap, BASEX, BASEY, BASEX - 1 + WIDTH * map->width, BASEY + EXTRA - 1 + HEIGHT * map->height, makecol( 0, 0, 0 ) );
    
    for ( int i = 0; i < map->width; i++ )
    {
        for ( int j = 0; j < map->height; j++ )
        {
            x = i * WIDTH + BASEX;
            y = j * HEIGHT + BASEY + EXTRA;

            if ( map->cover[ i + j * map->width ] > 0 )
            {
                color = makecol( 224, 224, 255 );

                if ( ( mouse_b & 1 ) && !dead && !cool )
                {
                    if ( x <= mouse_x && x + WIDTH > mouse_x &&
                         y <= mouse_y && y + WIDTH > mouse_y )
                    {
                        color = makecol( 128, 128, 255 );
                    }
                }
                
                rectfill( bitmap, x, y, x + WIDTH - 1, y + HEIGHT - 1, color );
                if ( map->cover[ i + j * map->width ] == 1 )
                {
                    masked_blit( images, bitmap, 85, 0, x+(WIDTH-17)/2, y+(HEIGHT-16)/2, 17, 16 );
                }
                else
                {
                    masked_blit( images, bitmap, 68, 0, x+(WIDTH-17)/2, y+(HEIGHT-16)/2, 17, 16 );
                }
            }
            else
            {
                p = get( map, i, j );
                color = makecol( 255, 255, 255 );
            
                if ( p == MINE + 1 )
                {
                    color = makecol( 255, 255, 0 );
                }
                rectfill( bitmap, x, y, x + WIDTH - 1, y + HEIGHT - 1, color );

                if ( p >= 1 && p <= 8 )
                {
                    textprintf_centre( bitmap, font, x + WIDTH / 2, y + ( HEIGHT - text_height( font ) ) / 2, makecol( 0, 0, 255 ), "%d", p );
                }
                if ( p == MINE || p == MINE + 1 )
                {
                    masked_blit( images, bitmap, 51, 0, x + ( WIDTH - 17 ) / 2, y + ( HEIGHT - 16 ) / 2, 17, 16 );
                }
            }

            rect( bitmap, x, y, x + WIDTH - 1, y + HEIGHT - 1, 0 );
        }
    }

    drawStats( bitmap, map );
}

int isNextTo( Map *map, int x, int y )
{
    int c[ 8 ][ 2 ] = { { -1,  0 }, {  1,  0 }, {  0, -1 }, {  0,  1 }, 
                        { -1, -1 }, { -1,  1 }, {  1, -1 }, {  1,  1 } };
    int amount = 0, p, cx, cy;

    for ( int i = 0; i < 8; i++ )
    {
        cx = x + c[ i ][ 0 ];
        cy = y + c[ i ][ 1 ];
        p = get( map, cx, cy );
    
        if ( p == MINE )
        {
            amount++;
        }
    }

    return amount;
}

void hitMine( Map *map )
{
    dead = true;

    for ( int i = 0; i < map->width; i++ )
    {
        for ( int j = 0; j < map->height; j++ )
        {
            if ( get( map, i, j ) == MINE && map->cover[ i + j * map->width ] != 2)
            {
                map->cover[ i + j * map->width ] = 0;
            }
        }
    }
}

void uncover( Map *map, int x, int y )
{
    int amount = 0;

    if ( map->cover[ x + y * map->width ] == 1 )
    {
        map->cover[ x + y * map->width ] = 0;

        if ( get( map, x, y ) == 0 )
        {
            if ( x > 0 ) 
                uncover( map, ( x - 1 ), ( y     ) );

            if ( x < map->width - 1 ) 
                uncover( map, ( x + 1 ), ( y     ) );

            if ( y > 0 ) 
                uncover( map, ( x     ), ( y - 1 ) );

            if ( y < map->height - 1 ) 
                uncover( map, ( x     ), ( y + 1 ) );

            if ( x > 0 && y > 0 ) 
                uncover( map, ( x - 1 ), ( y - 1 ) );

            if ( x < map->width - 1 && y > 0 ) 
                uncover( map, ( x + 1 ), ( y - 1 ) );

            if ( x > 0 && y < map->height - 1 ) 
                uncover( map, ( x - 1 ), ( y + 1 ) );

            if ( x < map->width - 1 && y < map->height - 1 ) 
                uncover( map, ( x + 1 ), ( y + 1 ) );
        }
    }
}

void checkMap( Map *map, int x, int y )
{
    if ( x >= BASEX && 
         x <  BASEX + map->width * WIDTH &&
         y >= BASEY + EXTRA && 
         y <  BASEY + EXTRA + map->height * HEIGHT )
    {
        x = ( x - BASEX ) / WIDTH;
        y = ( y - BASEY - EXTRA ) / HEIGHT;

        started = true;

        uncover( map, x, y );
        if ( get( map, x, y ) == MINE )
        {
            put( map, x, y, MINE + 1 );
            hitMine( map );
        }
    }
}

void markMap( Map *map, int x, int y )
{
    x = ( x - BASEX ) / WIDTH;
    y = ( y - BASEY - EXTRA ) / HEIGHT;

    if ( map->cover[ x + y * map->width ] == 1 )
    {
        map->cover[ x + y * map->width ] = 2;
    }
    else
    {
        if ( map->cover[ x + y * map->width ] == 2 )
        {
            map->cover[ x + y * map->width ] = 1;
        }
    }
}

void drawStats( BITMAP *bitmap, Map *map )
{
    int count = map->traps;
    int t = timer;
    char msg[ 10 ];

    for ( int i = 0; i < total; i++ )
    {
        if ( map->cover[ i ] == 2 )
        {
            count--;
        }
    }

    if ( count < 0 )
    {
        count += 1000;
    }

    if ( t > 999 )
    {
        t -= 1000;
    }

    sprintf( msg, "%03d", count );

    print( bitmap, msg, BASEX + 20, BASEY );

    sprintf( msg, "%03d", t );
    print( bitmap, msg, BASEX + WIDTH * map->width - 50, BASEY );

    draw_button( bitmap, map );
}

void print( BITMAP *bitmap, char *string, int x, int y )
{
    int count = 0;

    rectfill( bitmap, x, y + ( EXTRA - 15 ) / 2, x + 31, y + 18 + ( EXTRA - 15 ) / 2, makecol( 0, 0, 0 ) );

    while ( *string != '\0' )
    {
        masked_blit( images, bitmap, ( *string - '0' ) * 8, 16, x + 2 + ( count++ )* 10, y + 2 + ( EXTRA - 15 ) / 2, 8, 15 );
        string++;
    }
}

bool insideButton( int x, int y )
{
    int l, r, u, d, w, h;

    w = 36;
    h = 32;

    l = BASEX + ( WIDTH * currentWidth ) / 2 - w / 2;
    r = l + w;
    u = BASEY + ( EXTRA - h ) / 2;
    d = u + h;

    if ( x >= l && 
         x <= r && 
         y >= u && 
         y <= d )
    {
        return true;
    }
    return false;
}

void draw_button( BITMAP *bitmap, Map *map )
{
    int color = makecol( 255, 224, 224 ), l, r, u, d, x, w, h, c, e, count;

    w = 36;
    h = 32;
    c = 0;
    x = 0;
    l = BASEX + ( WIDTH * currentWidth ) / 2 - w / 2;
    r = l + w;
    u = BASEY + ( EXTRA - h ) / 2;
    d = u + h;
    e = 0;
    count = 0;

    if ( ( mouse_b & 1 ) && insideButton( mouse_x, mouse_y ) )
    {
        color = makecol( 255, 192, 192 );
    }
    
    if ( dead )
    {
        x = 34;
    }
    else
    {
        for ( int i = 0; i < total; i++ )
        {
            if ( map->cover[ i ] > 0 && map->data[ i ] != MINE && map->data[ i ] != MINE + 1 ) 
            {
                c = 1;
            }
        }
        if ( c == 0 )
        {
            cool = true;
            x = 17;
            for ( int i = 0; i < total; i++ )
            {
                if ( map->data[ i ] == MINE || map->data[ i ] == MINE + 1 ) 
                {
                    map->cover[ i ] = 2; 
                }
            }
        }
    }

    rectfill( bitmap, l, u, r, d, color );
    rect( bitmap, l, u, r, d, 0 );

    masked_stretch_blit( images, bitmap, x, 0, 17, 14, l + 2, u + 2, 34, 28 );
}

Map *newMap( Map *map )
{
    map = resetMap( map, currentWidth, currentHeight, currentTraps );

#ifdef ALLEGRO_WINDOWS
    resize( map->width * WIDTH, map->height * HEIGHT + EXTRA );
#endif

    return map;
}

Map *newMap( Map *map, int w, int h, int t )
{
    currentWidth = w;
    currentHeight = h;
    currentTraps = t;

    return newMap( map );
}
