

#ifdef ALLEGRO_WINDOWS

#define ALLEGRO_NO_MAGIC_MAIN
#define ALLEGRO_STATICLINK

#endif


#include <allegro.h>
#include <string.h>
#include <stdio.h>

#ifdef ALLEGRO_WINDOWS

#include <allegro\internal\aintern.h>
#include <winalleg.h>
#include "resource.h"

// only needed for MSVC
#define for if( false ) {} else for


// globals.cpp
extern BITMAP       *buffer;
extern int          SCREENW;
extern int          SCREENH;
extern HINSTANCE    hInstance;
extern HWND         hWnd;
extern HDC          hDC;
extern bool         done;
extern RECT         updateRect;

// wgdi.cpp
LRESULT CALLBACK WndProc( HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam );
int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow );
void resize( int w, int h );



// about_dialog.cpp
void about();
void help();

#endif

typedef struct
{
    int width;
    int height;
    int traps;
    int *data;
    int *cover;
} Map;

extern BITMAP *images;
extern Map *map;
extern char errstring[ 256 ];
extern bool mouse1_down;
extern bool mouse2_down;
extern bool dead;
extern bool started;
extern bool cool;
extern volatile int timer;


// main.cpp
int init();
void destroy();
void paint();
void loop();
void input();
int main();


// map.cpp
Map *create_map( int _width, int _height, int _traps );
Map *resetMap( Map *map, int _width, int _height, int _traps );
void destroy_map( Map *map );
void draw_map( BITMAP *bitmap, Map *map );
void checkMap( Map *map, int x, int y );
void markMap( Map *map, int x, int y );
int get( Map *map, int x, int y );
void put( Map *map, int x, int y, int p );
int isNextTo( Map *map, int x, int y );
void uncover( Map *map, int x, int y );
void drawStats( BITMAP *bitmap, Map *map );
void print( BITMAP *bitmap, char *string, int x, int y );
bool insideButton( int x, int y );
void draw_button( BITMAP *bitmap, Map *map );
Map *newMap( Map *map );
Map *newMap( Map *map, int w, int h, int t );
Map *custom_map();

