#include "main.h"

bool        done            = false;

#ifdef ALLEGRO_WINDOWS

int         SCREENW         = 0;
int         SCREENH         = 0;
HINSTANCE   hInstance       = NULL;
HWND        hWnd            = NULL;
HDC         hDC             = NULL;
RECT        updateRect;
int         dwStyle;
RECT        lpRect;

int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
    WNDCLASSEX WndClass;
    MSG Msg;

    hInstance = hInst;

    WndClass.cbSize        = sizeof(WNDCLASSEX);
    WndClass.style         = NULL;
    WndClass.lpfnWndProc   = WndProc;
    WndClass.cbClsExtra    = 0;
    WndClass.cbWndExtra    = 0;
    WndClass.hInstance     = hInstance;
    WndClass.hIcon         = LoadIcon(hInstance, (LPSTR)"allegro_icon");
    WndClass.hIconSm       = LoadIcon(hInstance, (LPSTR)"allegro_icon");
    WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    WndClass.hbrBackground = NULL;
    WndClass.lpszMenuName  = "MAINMENU";
    WndClass.lpszClassName = "MyClassName";

    if( !RegisterClassEx( &WndClass ) )
    {
        MessageBox(0, "Window Registration Failed!", "Error!", MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL);
        return 0;
    }

    dwStyle = WS_OVERLAPPED | WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU;

    lpRect.left = 0;
    lpRect.right = 19 * 9 + 4;
    lpRect.top = 0;
    lpRect.bottom = 18 * 9 + 40 + 4;

    SCREENW = lpRect.right - lpRect.left;
    SCREENH = lpRect.bottom - lpRect.top;

    AdjustWindowRect( &lpRect, dwStyle, TRUE );

    hWnd = CreateWindowEx( WS_EX_CLIENTEDGE,
                           "MyClassName",
                           "MouseTrap",
                           dwStyle,
                           ( GetSystemMetrics( SM_CXSCREEN ) - ( lpRect.right - lpRect.left ) ) / 2,
                           ( GetSystemMetrics( SM_CYSCREEN ) - ( lpRect.bottom - lpRect.top ) ) / 2,
                           lpRect.right - lpRect.left, 
                           lpRect.bottom - lpRect.top,
                           NULL, 
                           NULL, 
                           hInstance, 
                           NULL);


    if( hWnd == NULL )
    {
        MessageBox(0, "Window Creation Failed!", "Error!", MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL);
        return 0;
    }

    hDC = GetDC( hWnd );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

    init();

    while ( !done )
    {
        while ( PeekMessage( &Msg, hWnd, 0, 0, PM_REMOVE ) )
        {
            TranslateMessage( &Msg );
            DispatchMessage( &Msg );
        }

        loop();
        paint();
    }

    destroy();
    allegro_exit();
   
    return Msg.wParam;
}

void resize( int w, int h )
{
    RECT lpRect, rc;
    int x, y;

    lpRect.left = 0;
    lpRect.right = w + 4;
    lpRect.top = 0;
    lpRect.bottom = h + 4;

    SCREENW = lpRect.right - lpRect.left;
    SCREENH = lpRect.bottom - lpRect.top;

    if ( buffer->w != SCREENW || buffer->h != SCREENH )
    {
        destroy_bitmap( buffer );
        buffer = create_bitmap( SCREENW, SCREENH );
    }

    AdjustWindowRect( &lpRect, dwStyle, TRUE );

    GetWindowRect( hWnd, &rc );
   
    x = rc.left;
    y = rc.top;

    MoveWindow( hWnd, x,
                      y,
                      lpRect.right - lpRect.left, 
                      lpRect.bottom - lpRect.top,
                      TRUE );
    paint();
}

LRESULT CALLBACK WndProc( HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam )
{
    bool active = false;

    switch( Message )
    {
    case WM_CREATE:
        {
        }
        break;

    case WM_COMMAND:
        {
            switch( LOWORD(wParam) )
            {
            case IDM_ABOUT:
                {
                    about();
                } break;
            
            case IDM_NEW1:
                {
                    map = newMap( map, 9, 9, 10 );
                } break;

            case IDM_NEW2:
                {
                    map = newMap( map, 16, 12, 30 );
                } break;

            case IDM_NEW3:
                {
                    map = newMap( map, 32, 24, 99 );
                } break;

            case IDM_NEW4:
                {
                    map = custom_map();
                } break;

            case IDM_HELP:
                {
                    help();
                } break;
            
            case IDM_EXIT:
                {
                    SendMessage( hwnd, WM_CLOSE, wParam, lParam );
                } break;
            }
        }
        break;

    case WM_CLOSE:
        {
            SendMessage( hwnd, WM_DESTROY, wParam, lParam );            
        }
        break;

    case WM_MOUSEMOVE:
        {
            mouse_x = LOWORD(lParam); 
            mouse_y = HIWORD(lParam);
        }
        break;

    case WM_LBUTTONDOWN:
        {
            mouse_b |= 1;
        }
        break;

    case WM_LBUTTONUP:
        {
            if ( mouse_b & 1 )
            {
                mouse_b ^= 1;
            }
        }
        break;

    case WM_RBUTTONDOWN:
        {
            mouse_b |= 2;
        }
        break;

    case WM_RBUTTONUP:
        {
            if ( mouse_b & 2 )
            {
                mouse_b ^= 2;
            }
        }
        break;

    case WM_DESTROY:
        {
            done = true;
        }
      break;

    default:
        {
            return DefWindowProc( hwnd, Message, wParam, lParam );
        }
    }

    return FALSE;
}

#else

int main(void)
{

    if ( init() == 0 )
    {
        while ( !done )
        {   
            if ( key[ KEY_ESC ] )
            {
                done = true;
            }

            loop();
            paint();
        }
    }

    destroy();

    return 0;
}
END_OF_MAIN();

#endif

