#include "main.h"

#ifdef ALLEGRO_WINDOWS

LRESULT CALLBACK HelpDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message)
    {
    case WM_COMMAND:
        {
            if ( LOWORD(wParam) == IDOK )
            {
                EndDialog( hDlg, IDOK );
            }
        } break;

    case WM_INITDIALOG:
        {
            SetDlgItemText( hDlg, IDC_EDIT1, "Instructions: "
                                              "The idea of the game is to get all the cheese. " 
                                              "Except that you have to look out for cats. If "
                                              "you think a cheese block is hiding a cat then "
                                              "put a flag on it. When all the cats are covered " 
                                              "with flags then the game is won. Find a cat and "
                                              "you lose." );
        } break;

    case WM_MOVE:
        {
            paint();
        } break;

    case WM_CLOSE:
        {
            EndDialog( hDlg, IDOK );
        }
        break;
    default:
        {
            return FALSE;
        }
    }
        
    return TRUE;
}

void help()
{
    DialogBox( hInstance, (LPCTSTR) IDD_HELP_DIALOG, NULL, (DLGPROC) HelpDialogProc );
}

#endif

