#include "main.h"

BITMAP *buffer          = NULL;
BITMAP *images          = NULL;
Map *map                = NULL;
char errstring[ 256 ]   = "Thank you for playing:\n\n       MouseTrap";
bool mouse1_down        = false;
bool mouse2_down        = false;
bool dead               = false;
volatile int timer      = 0;
bool started            = false;
bool cool               = false;

void inc_timer()
{
    if ( started && !dead && !cool )
    {
        timer++;
    }
}
END_OF_FUNCTION( inc_timer );

int init()
{

#ifdef ALLEGRO_WINDOWS
    win_set_window( hWnd );

    allegro_init();
    if ( install_keyboard() < 0 )
    {
        MessageBox( hWnd, "Keyboard!","Error",MB_OK | MB_ICONEXCLAMATION );
    }
    if ( install_timer() < 0 )
    {
        MessageBox( hWnd, "Timer!","Error",MB_OK | MB_ICONEXCLAMATION );
    }

    set_color_depth( desktop_color_depth() );
    set_color_conversion(COLORCONV_TOTAL);
    set_gdi_color_format();

    HBITMAP hbitmap = LoadBitmap( hInstance, "IDB_BITMAP" );
    images = convert_hbitmap_to_bitmap( hbitmap );
    DeleteObject( hbitmap );

    buffer = create_bitmap( SCREENW, SCREENH );

#else

    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();


    set_color_depth( 16 );
    if ( set_gfx_mode( GFX_AUTODETECT, 640, 480, 0, 0 ) < 0 )
    {
        set_color_depth( 15 );
        if ( set_gfx_mode( GFX_AUTODETECT, 640, 480, 0, 0 ) < 0 )
        {
            strcpy( errstring, "Error: Setting graphics mode!" );
            return -1;
        }
    }

    images = load_bmp( "images.bmp", NULL );

    buffer = create_bitmap( SCREEN_W, SCREEN_H );

#endif

    if ( images == NULL )
    {
        strcpy( errstring, "Error: Loading graphic images!" );
        return -1;
    }

    if ( buffer == NULL )
    {
        strcpy( errstring, "Error: Setting creating double buffer!" );
        return -1;
    }

    srand((int)time(NULL));
    text_mode( -1 );

    LOCK_VARIABLE( timer );
    LOCK_FUNCTION( (void*)inc_timer );
    install_int( inc_timer, 1000 );

    map = create_map( 9, 9, 10 );
    if ( map == NULL )
    {
        strcpy( errstring, "Error: Creating map!" );
        return -1;
    }

    return 0;
}

void destroy()
{
#ifndef ALLEGRO_WINDOWS

    set_gfx_mode( GFX_TEXT, 0 ,0, 0, 0 );
    allegro_message( errstring );

#endif

    if ( buffer != NULL  )
    {
        destroy_bitmap( buffer );
    }

    if ( images != NULL  )
    {
        destroy_bitmap( images );
    }

    if ( map != NULL )
    {
        destroy_map( map );
    }
}

void paint()
{
    draw_map( buffer, map );

#ifdef ALLEGRO_WINDOWS

    blit_to_hdc( buffer, hDC, 0, 0, 0, 0, SCREENW, SCREENH );

#else

    masked_blit( images, buffer, 102, 0, mouse_x, mouse_y, 11, 19 );

    blit( buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );

#endif
}

void loop()
{
    if ( key[ KEY_F1 ] )
    {
        map = newMap( map, 9, 9, 10 );
    }
    if ( key[ KEY_F2 ] )
    {
        map = newMap( map, 16, 12, 30 );
    }
    if ( key[ KEY_F3 ] )
    {
        map = newMap( map, 32, 24, 99 );
    }

    if ( mouse_b & 1 )
    {
        mouse1_down = true;                    
    }
    else
    {
        if ( mouse1_down )
        {
            if ( insideButton( mouse_x, mouse_y ) )
            {   
                map = newMap( map );
            }
            else
            {
                if ( !dead && !cool )
                {
                    checkMap( map, mouse_x, mouse_y );
                }
            }
        }
        mouse1_down = false;
    }
    
    if ( mouse_b & 2 )
    {
        mouse2_down = true;                    
    }
    else
    {
        if ( mouse2_down && !cool )
        {
            markMap( map, mouse_x, mouse_y );
        }
        mouse2_down = false;
    }
}

