// thematrixeatsyou@yahoo.co.nz - created 2005-06

#include <stdio.h>
#include <math.h>
#include <time.h>

#include <allegro.h>

typedef struct{
    signed char lblock[192][160];
    signed int vblock[192][160];
    unsigned int iblock[192][160];
    signed int xblock[192][160];
    int lw,lh;
    int scrc;
    char *scrv[64];
}lcoredata;

typedef struct{
    signed int x,y;
    int bbx1,bby1,bbx2,bby2;
    int fr;
    int hittype;
    int flags;
    int nextpath,npdelay;
    int bulx,buly,bult;
    int ptrigpos[4],ptrigtype[4],pttx[4],ptty[4];
    BITMAP *bulg;
}lscript;

#define mf_gravity 1
#define mf_dontfall 2

#define mh_bounce 1
#define mh_punch 2

#define mtt_not 1
#define mtt_blocked 2 //positioned
#define mtt_senseplayer 4 //if directional then positioned, else PTTX=radius
#define mtt_directional 128

// Monster handler incomplete.
// But hey, it's still good.
typedef struct{
    int x,y;
    int bbx1,bby1,bbx2,bby2;
    BITMAP *gfx[32];
    int gfxs;
    int fr,delay;
    int health,maxh;
    int flags,type;
    int hittype;
    int ptrigpos[16],ptrigtype[16],pttx[16],ptty[16];
    lscript path[64];
    int ppos;
    int pts;
}lmon;
typedef struct{
    int x,y;
    int bbx1,bby1,bbx2,bby2;
    int mtemplate;
    int gfxs;
    int fr,delay;
    int health,maxh;
    int flags,type;
    int hittype;
    int ptrigpos[16],ptrigtype[16],pttx[16],ptty[16];
    int ppos;
    int pts;
    lscript cpath;
}lmona;
signed char ctf[256];
unsigned int vctf[256];
unsigned int ictf[256];
unsigned int xctf[256];
unsigned int mctf[256];
char stbuf[256];//,stcmd[8][64];
int gdat1,gdat2,gdat3;
int score,lives,level;

int pyrx,pyry,pyrm,pyrf,pyrfs,pyrfm,pyrvx,pyrvy,pyrs,pyrsy,pyrom;
int opx,opy,vopx,vopy;
int camx,camy;
long oldclk,newclk;
char bonus[40];
int bontime;

#define gm_quit 0
#define gm_play 1
int gamemode;

#define pup_fly 1
int pup,pupd;

long ctr;
int mons,omons;

lcoredata clevel,levbak;
lmon enemytemplate[32],etblank;
lmona enemy[256],enemybak[256],eblank;

BITMAP *blah,*tileset,*itemset,*tbuf,*icons[32],*tloader;

/// Functions...
// compile_level():
// Converts a level###.txt into standard game format.
lcoredata cl_config(FILE *ldat2,lcoredata leve){
    lcoredata result=leve;
    int quit=0;
    printf("Getting configuration...\n");
    while(quit==0){
    fscanf(ldat2,"%s",stbuf);
    strlwr(&stbuf);
    if(!stricmp(stbuf,"end")) quit=1;
    else if(!stricmp(stbuf,"ctf")){
    fscanf(ldat2," %c %i",&stbuf[0],&quit);
    vctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    ctf[stbuf[0]]=quit;
    printf("  CTF converts %c to %02xh (mask %02xh)\n",stbuf[0],vctf[stbuf[0]],ctf[stbuf[0]]);
    quit=0;
    }else if(!stricmp(stbuf,"item")){
    fscanf(ldat2," %c %i",&stbuf[0],&quit);
    vctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    ctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    ictf[stbuf[0]]=quit;
    printf("  ICTF converts %c to %02xh (mask %02xh, item %02xh)\n"
    ,stbuf[0],vctf[stbuf[0]],ctf[stbuf[0]],ictf[stbuf[0]]);
    quit=0;
    }else if(!stricmp(stbuf,"mon")){
    fscanf(ldat2," %c %i",&stbuf[0],&quit);
    vctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    ctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    mctf[stbuf[0]]=quit;
    printf("  MCTF converts %c to %02xh (mask %02xh, monster %02xh)\n"
    ,stbuf[0],vctf[stbuf[0]],ctf[stbuf[0]],ictf[stbuf[0]]);
    quit=0;
    }else if(!stricmp(stbuf,"xctf")){
    fscanf(ldat2," %c %i",&stbuf[0],&quit);
    vctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    ctf[stbuf[0]]=quit;
    fscanf(ldat2,"%i",&quit);
    xctf[stbuf[0]]=quit;
    printf("  XCTF converts %c to %02xh (mask %02xh, extra %02xh)\n"
    ,stbuf[0],vctf[stbuf[0]],ctf[stbuf[0]],ictf[stbuf[0]]);
    quit=0;
    }else if(!stricmp(stbuf,"player")){
        fscanf(ldat2,"%i%i",&pyrx,&pyry);pyrx*=16;pyry*=16;vopx=opx=pyrx;vopy=opy=pyry;}
    }
    return result;
}

int cl_monster(FILE *ldat2){
    int quit=0;
    FILE *mdat;
    while(quit==0){
    fscanf(ldat2,"%s",stbuf);
    strlwr(&stbuf);
    if(!stricmp(stbuf,"end")) quit=1;
    else if(!stricmp(stbuf,"mon")){
    printf("Getting monster data...\n");
    fscanf(ldat2," %i %s",&quit,&stbuf);
    printf("Compiling monster #%i...",quit);
    mdat=fopen(stbuf,"r");
    if(mdat!=NULL){
    printf("\n");
    compile_monster(mdat,quit-1);
    }else{
    printf("Failed.\n");
    }
    quit=0;
    }}    
    return 0;
}
// I put this *here* because it's used in cl_level()
// not in any cm_*() functions
// but it's used in handle_monster()
// so I might move it
int trans_monster(int src, int dest,int x, int y,int pathth){
    enemy[dest].bbx1=enemytemplate[src].bbx1;
    enemy[dest].bbx2=enemytemplate[src].bbx2;
    enemy[dest].bby1=enemytemplate[src].bby1;
    enemy[dest].bby2=enemytemplate[src].bby2;
    enemy[dest].gfxs=enemytemplate[src].gfxs;
    enemy[dest].fr=enemytemplate[src].fr;
    enemy[dest].delay=enemytemplate[src].delay;
    enemy[dest].health=enemytemplate[src].health;
    enemy[dest].maxh=enemytemplate[src].maxh;
    enemy[dest].flags=enemytemplate[src].flags;
    enemy[dest].type=enemytemplate[src].type;
    enemy[dest].ptrigpos[16]=enemytemplate[src].ptrigpos[16];
    enemy[dest].ptrigtype[16]=enemytemplate[src].ptrigtype[16];
    enemy[dest].pttx[16]=enemytemplate[src].pttx[16];
    enemy[dest].ptty[16]=enemytemplate[src].ptty[16];
    enemy[dest].ppos=enemytemplate[src].ppos;
    enemy[dest].cpath=enemytemplate[src].path[pathth];
    enemy[dest].pts=enemytemplate[src].pts;
    enemy[dest].mtemplate=src;
    enemy[dest].x=x;
    enemy[dest].y=y;
}
lcoredata cl_level(FILE *ldat2,lcoredata leve){
    lcoredata result=leve;
    int quit=0,w=0,h=0,x,y;
    mons=0;
    printf("Constructing level data...\n");
    fscanf(ldat2,"%i %i",&w,&h);
    printf("  Level is %ix%i\n",w,h);
    for(y=0;y<h;y++){
    for(x=0;x<w;x++){
        stbuf[0]=fgetc(ldat2);
        if(stbuf[0]=='\n') x--;
        else{
        result.lblock[y][x]=ctf[stbuf[0]]-1;
        result.vblock[y][x]=vctf[stbuf[0]]-1;
        result.iblock[y][x]=ictf[stbuf[0]]-1;
        result.xblock[y][x]=xctf[stbuf[0]]-1;
        if(mctf[stbuf[0]]!=0){
            trans_monster(mctf[stbuf[0]]-1,mons,x*16,y*16,0);
            enemybak[mons]=enemy[mons];
            mons++;
        }
        }
        printf("%c",result.lblock[y][x]+1);
    }}
    printf("\n");
    result.lw=w;result.lh=h;
    omons=mons;
    return result;
}
lcoredata compile_level(int levnum){
    FILE *ldat;
    lcoredata result;
    int i;
    // Trust me, this is NEEDED.
    for(i=0;i<255;i++){
        enemy[i]=eblank;
    }for(i=0;i<32;i++){
        enemytemplate[i]=etblank;
    }
    printf("Compiling level data...\n");
    //Open file for reading as ASCII.
    sprintf(stbuf,"level%i.txt",levnum);
    printf("Loading file %s...",stbuf);
    ldat=fopen(stbuf,"r");
    if(ldat!=NULL){
    printf("OK!\nReading file...\n");
    while(!feof(ldat)){
        fscanf(ldat,"%s",stbuf);
        strlwr(&stbuf);
    if(!stricmp(stbuf,"config")) result=cl_config(ldat,result);
    else if(!stricmp(stbuf,"level")) result=cl_level(ldat,result);
    else if(!stricmp(stbuf,"monster")) cl_monster(ldat);
    stbuf[0]='\0';
    }
    }else{
    printf("Failed.\n");
    }
    fclose(ldat);
    printf("Compiled successfully.");
    printf("  Level is %ix%i\n",result.lw,result.lh);
    sprintf(bonus,"Level %i",levnum);
    bontime=100;
    return result;
}
// itemhandler():
// When a player collects an item, do this stuff...
int itemhandler(int ix,int iy){
    switch(gdat1){
    case 0:
        score+=20;
        break;
    case 1:
        pyrvy=-15;
        pyrsy=0;
        clevel.iblock[(pyry+8)/16][(pyrx+8)/16]=1;
        pyry-=16;
        break;
    case 2:
        score+=100;
        if(lives<9){lives++;strcpy(bonus,"Extra Life!");}
        else{score+=700;strcpy(bonus,"700 Points!");}
        bontime=50;
        break;
    case 3:
        level++;
        clevel=compile_level(level);
        levbak=clevel;
        break;
    case 4:
        pup=1;
        pupd=500;
        break;
    }
}
// playerdied():
// Death handler.
int playerdied(void){
    int i;
    clevel=levbak;
    pyrx=opx;
    pyry=opy;
    pyrm=pyrf=pyrfs=pyrfm=pyrvx=pyrvy=pyrs=pyrsy=pyrom=0;
    lives--;
    mons=omons;
    for(i=0;i<mons;i++)enemy[i]=enemybak[i];
    pup=0;pupd=0;
    if(lives==0){
        score=0;
        pyrx=opx=vopx;pyry=opy=vopy;
        lives=3;
        level=1;
        clevel=compile_level(level);
        levbak=clevel;
    }
}

// monster() functions:
// Compilers and handlers.
int cm_config(FILE *mdat3, int cm2){
    int quit=0,i;
    printf("  Configuring...\n");
    while(quit==0){
    fscanf(mdat3,"%s",stbuf);
    strlwr(&stbuf);
    if(!stricmp(stbuf,"end")) quit=1;
    else if(!stricmp(stbuf,"gfx")){
    printf("    Getting graphics data...\n");
    fscanf(mdat3,"%s",stbuf);
    tloader=load_bitmap(stbuf,NULL);
    for(i=0;i<32;i++){
    enemytemplate[cm2].gfx[i]=create_bitmap(tloader->h,tloader->h);
    blit(tloader,enemytemplate[cm2].gfx[i],
    tloader->h*i,0,0,0,tloader->h,tloader->h);}
    }else if(!stricmp(stbuf,"health")){
    fscanf(mdat3,"%i",&enemytemplate[cm2].health);
    enemytemplate[cm2].maxh=enemytemplate[cm2].health;
    printf("    Health set to %i.\n",enemytemplate[cm2].health);
    }else if(!stricmp(stbuf,"score")){
    fscanf(mdat3,"%i",&enemytemplate[cm2].pts);
    printf("    Score set to %i.\n",enemytemplate[cm2].pts);
    }
    }
    printf("  Configuration complete.\n");
    return 0;
}
int cm_frame(FILE *mdat3, int cm2){
    int quit=0,i,fra;
    printf("  Getting frame info...\n");
    fscanf(mdat3,"%i",&fra);
    fra--;
    printf("  Getting frame info for frame %i...\n",fra+1);
    enemytemplate[cm2].path[fra].fr=fra;
    while(quit==0){
    fscanf(mdat3,"%s",stbuf);
    strlwr(&stbuf);
    if(!stricmp(stbuf,"end")) quit=1;
    else if(!stricmp(stbuf,"copy")){
    fscanf(mdat3,"%i",&quit);
    printf("    Copying from %i to %i...\n",quit,fra+1);
    enemytemplate[cm2].path[fra]=enemytemplate[cm2].path[quit-1];
    quit=0;
    }else if(!stricmp(stbuf,"bbox")){
    fscanf(mdat3,"%i%i%i%i"
    ,&enemytemplate[cm2].path[fra].bbx1
    ,&enemytemplate[cm2].path[fra].bby1
    ,&enemytemplate[cm2].path[fra].bbx2
    ,&enemytemplate[cm2].path[fra].bby2
    );
    printf("    BBox set.\n");
    }else if(!stricmp(stbuf,"flags")){
    fscanf(mdat3,"%i",&enemytemplate[cm2].path[fra].flags);
    printf("    Flags set.\n");
    }else if(!stricmp(stbuf,"hflags")){
    fscanf(mdat3,"%i",&enemytemplate[cm2].path[fra].hittype);
    printf("    Hit flags set.\n");
    }else if(!stricmp(stbuf,"move")){
    fscanf(mdat3,"%i%i",&enemytemplate[cm2].path[fra].x
    ,&enemytemplate[cm2].path[fra].y);
    printf("    Motion set.\n");
    }else if(!stricmp(stbuf,"trig")){
    fscanf(mdat3,"%i",&quit);
    fscanf(mdat3,"%i%i%i%i"
    ,&enemytemplate[cm2].path[fra].ptrigpos[quit]
    ,&enemytemplate[cm2].path[fra].ptrigtype[quit]
    ,&enemytemplate[cm2].path[fra].pttx[quit]
    ,&enemytemplate[cm2].path[fra].ptty[quit]);
    printf("    Trigger set.\n");
    quit=0;
    }else if(!stricmp(stbuf,"next")){
    fscanf(mdat3,"%i",&enemytemplate[cm2].path[fra].nextpath);
    enemytemplate[cm2].path[fra].nextpath--;
    printf("    Next path position set.\n");
    }else if(!stricmp(stbuf,"delay")){
    fscanf(mdat3,"%i",&enemytemplate[cm2].path[fra].npdelay);
    printf("    Delay set.\n");
    }
    }
    printf("  Finished with frame %i.\n",fra+1);
    return 0;
}
int compile_monster(FILE *mdat2, int cm){
    int quit=0;
    while(!feof(mdat2)){
    fscanf(mdat2,"%s",stbuf);
    strlwr(&stbuf);
    if(!stricmp(stbuf,"config")) cm_config(mdat2,cm);
    else if(!stricmp(stbuf,"frame")) cm_frame(mdat2,cm);
    }
    enemytemplate[cm].delay=enemytemplate[cm].path[0].npdelay;
    return 0;
}
int destroy_monster(int mo){
    int i;
    mons--;
    for(i=mo;i<mons;i++){
        enemy[i]=enemy[i+1];
    }
}
int handle_monster(int cm){
    int ct,flg,i;
    ct=enemy[cm].mtemplate;
    //// DRAW
    draw_sprite(blah,
    enemytemplate[ct].gfx[enemy[cm].fr]
    ,enemy[cm].x-camx,enemy[cm].y-camy);
    //// TRIGGER
    for(i=0;i<4;i++){
    if(enemy[cm].cpath.ptrigtype[i]==0) break;
        flg=FALSE;
    if(enemy[cm].cpath.ptrigtype[i] & mtt_blocked){
        //printf("Calling BLOCKED %i\n",i);
        if(clevel.lblock[(enemy[cm].cpath.ptty[i]+enemy[cm].y)/16]
        [(enemy[cm].cpath.pttx[i]+enemy[cm].x)/16]>=0){
            flg=TRUE;
        }
    }
    if(enemy[cm].cpath.ptrigtype[i] & mtt_not)flg=!flg;
    if(flg){
        //printf("Trigger set. ");
        // Trigger set. Let's jump over...
        flg=enemy[cm].cpath.ptrigpos[i]-1;
        trans_monster(ct,cm,enemy[cm].x,enemy[cm].y,flg);
        enemy[cm].fr=flg;
        enemy[cm].delay=5;
        //printf("Frame now set to %i==%i.\n",enemy[cm].fr,flg);
    }}
    //// HIT_TYPE
        if(pyrx+14>enemy[cm].x+enemy[cm].cpath.bbx1
        & pyrx+1<enemy[cm].x+enemy[cm].cpath.bbx2){
        if(pyry+15>enemy[cm].y+enemy[cm].cpath.bby1
        & pyry<enemy[cm].y+enemy[cm].cpath.bby2){
            if(pyrvy>0 & (enemy[cm].cpath.hittype & mh_bounce)){
                //pyrvy*=-1;
                pyrvy=-8;
                pyry=enemy[cm].y-16;
                enemy[cm].health--;
                if(enemy[cm].health<=0){
                    score+=enemy[cm].pts;
                    destroy_monster(cm);
                }
            }else{
                playerdied();
            }
        }}
    if((enemy[cm].cpath.hittype & mh_punch) & key[KEY_ENTER]){
        if((pyrom==1 & enemy[cm].y>=pyry-8 & enemy[cm].y<=pyry+8
        & enemy[cm].x>=pyrx+16 & enemy[cm].x<=pyrx+24)
        | (pyrom==2 & enemy[cm].y>=pyry-8 & enemy[cm].y<=pyry+8
        & enemy[cm].x>=pyrx & enemy[cm].x<=pyrx-8)){
        enemy[cm].health--;
        if(enemy[cm].health<=0){
            score+=enemy[cm].pts;
            destroy_monster(cm);
        }}
    }
    //// DELAY
    enemy[cm].delay--;
    if(enemy[cm].delay>0) return 0;
    //// MOVE
    enemy[cm].x+=enemy[cm].cpath.x;
    enemy[cm].y+=enemy[cm].cpath.y;
    enemy[cm].fr=enemy[cm].cpath.nextpath;
    enemy[cm].cpath=enemytemplate[ct].path[enemy[cm].fr];
    enemy[cm].delay=enemy[cm].cpath.npdelay;
    //printf("%i",enemy[cm].cpath.npdelay);
    //printf("Lolz %i\n",enemy[cm].delay);
    return 1;
}
END_OF_FUNCTION(handle_monster)
/// Code....

//////////////
// Gameloop
//
int gameloop(void){
    int x,y,i;
    //// CAM
    if(pyrx<152) camx=0;
    else if(pyrx>clevel.lw*16-168) camx=clevel.lw*16-320;
    else camx=pyrx-152;
    if(pyry<100) camy=0;
    else if(pyry>clevel.lh*16-108) camy=clevel.lh*16-208;
    else camy=pyry-100;
    //// GFX
    for(y=0;y<clevel.lh;y++){
    for(x=0;x<clevel.lw;x++){
        if(x*16>camx-16 & x*16<camx+336 & y*16>camy-16 & y*16<camy+216){
        if(clevel.vblock[y][x]!=-1)masked_blit(tileset,blah,
        ((clevel.vblock[y][x])%16)*16,
        ((clevel.vblock[y][x])/16)*16,
        x*16-camx,y*16-camy,16,16);
        if(clevel.iblock[y][x]!=-1 & clevel.lblock[y][x]==-1) masked_blit(itemset,blah,
        ((clevel.iblock[y][x])%16)*16,
        ((clevel.iblock[y][x])/16)*16,
        x*16-camx,y*16-camy,16,16);
        }
    //textprintf(blah,font,x*16-camx,y*16-camy,makecol(255,255,255),"%i",clevel.vblock[y][x]);
    //textprintf(blah,font,x*16-camx,y*16-camy+8,makecol(255,255,255),"%i",clevel.iblock[y][x]);
    }}
    for(i=0;i<mons;i++){
        handle_monster(i);
    }
    //textprintf(blah,font,0,0,makecol(255,255,255),"%i",enemy[0].fr);
    //textprintf(blah,font,0,8,makecol(255,255,255),"%i",enemy[0].delay);
    switch(pyrfm){
    case 0:
    masked_blit(tileset,blah,32,0,pyrx-camx,pyry-camy,16,16);
    break;
    case 1:
    masked_blit(tileset,blah,48+pyrf*16,0,pyrx-camx,pyry-camy,16,16);
    pyrfs++;
    if(pyrfs>=10){pyrfs=0;pyrf+=1;if(pyrf>=4)pyrf=0;}
    pyrom=1;
    break;
    case 2:
    blit(tileset,tbuf,48+pyrf*16,0,0,0,16,16);
    draw_sprite_h_flip(blah,tbuf,pyrx-camx,pyry-camy);
    pyrfs++;
    pyrom=2;
    if(pyrfs>=10){pyrfs=0;pyrf+=1;if(pyrf>=4)pyrf=0;}
    break;
    }
    for(i=0;i<lives;i++)draw_sprite(blah,icons[0],312-i*8,192);
    textprintf(blah,font,0,192,makecol(255,255,255),"Score: %05i",score);
    if(bontime>0){
    textprintf_centre(blah,font,160,0,makecol(255,255,255),"%s",bonus);
    bontime--;
    }
    //textprintf_right(blah,font,320,192,makecol(255,255,255),"%ld",ctr);
    //ctr++;
    stretch_blit(blah,screen,0,0,320,200,0,40,640,400);
    rectfill(screen,0,0,640,40,makecol(0,0,255));
    rectfill(screen,0,440,640,480,makecol(0,0,255));
    clear_to_color(blah,makecol(0,0,255));
    //// PLAYER
    pyry+=pyrvy;
    // Roof handler
    if((clevel.lblock[(pyry)/16][(pyrx+1)/16]>=0 |
    clevel.lblock[(pyry)/16][(pyrx+14)/16]>=0) & pyrvy<0){
        pyrvy=0;
        pyry=((pyry-1)/16)*16+16;
    }
    pyrx+=pyrvx;
    // Dir handlers
    if(pyrfm==0){
        if(pyrm==1){
            pyrfm=1;
            pyrvx=1;
        }else if(pyrm==2){
            pyrfm=2;
            pyrvx=-1;
        }pyrs=0;
    }else if(pyrfm==1){
        pyrs++;
        if(pyrm==1){
            if(pyrs>=8 && pyrvx<4){
                pyrvx*=2;
            }
        }else{
            if(pyrs>=8 && pyrvx>0){
                if(pyrvx<=1){pyrvx=0;pyrfm=0;}
                pyrvx=pyrvx/2;
            }
        }
        // Smack into wall handler 1
        if(clevel.lblock[(pyry+1)/16][(pyrx+14)/16]>=0){
            pyrx=((pyrx-2)/16)*16;
            //pyry=(pyry/16)*16;
            pyrvx=0;pyrfm=0;
        }
    }else if(pyrfm==2){
        pyrs++;
        if(pyrm==2){
            if(pyrs>=8 && pyrvx>-4){
                pyrvx*=2;
            }
        }else{
            if(pyrs>=8 && pyrvx<0){
                if(pyrvx>=-1){pyrvx=0;pyrfm=0;}
                pyrvx=pyrvx/2;
            }
        }
        // Smack into wall handler 2
        if(clevel.lblock[(pyry+1)/16][(pyrx+1)/16]>=0){
            pyrx=((pyrx+1)/16)*16+16;
            //pyry=(pyry/16)*16;
            pyrvx=0;pyrfm=0;
        }
    }
    // Fall/floor handler
    if(clevel.lblock[pyry/16+1][(pyrx+1)/16]<0
    & clevel.lblock[pyry/16+1][(pyrx+14)/16]<0){
        pyrsy++;
        if(pyrsy>=4){
        if(pyrvy==0){
            pyrvy=1;
        }else if(pyrvy>0 && pyrvy<4){
            pyrvy*=2;
        }else if(pyrvy<0){
            if(pyrvy==-1)pyrvy=0;
            pyrvy=pyrvy/2;
        }pyrsy=0;}
    }else{pyrvy=0;pyrsy=0;pyry=((pyry)/16)*16;
    // Death handlers: Landing on mask #3(2)
        if(clevel.lblock[pyry/16+1][(pyrx+5)/16]==2
    | clevel.lblock[pyry/16+1][(pyrx+10)/16]==2){
            playerdied();
        }
    }

    // Death handlers: Bottom of level
    if(pyry>=clevel.lh*16-16){
        playerdied();
    }
    // Checkpoint (mask #-1(-2))
    if(clevel.lblock[(pyry+8)/16][(pyrx+8)/16]==-2){
        clevel.lblock[(pyry+8)/16][(pyrx+8)/16]=-1;
        opx=((pyrx+8)/16)*16;opy=((pyry+8)/16)*16;
        strcpy(bonus,"Checkpoint!");
        bontime=50;
        levbak=clevel;
        omons=mons;
        for(i=0;i<mons;i++) enemybak[i]=enemy[i];
    }
    // Ooh, I picked up an item, heh heh
    if(clevel.iblock[(pyry+8)/16][(pyrx+8)/16]!=-1){
        gdat1=clevel.iblock[(pyry+8)/16][(pyrx+8)/16];
        clevel.iblock[(pyry+8)/16][(pyrx+8)/16]=-1;
        itemhandler((pyrx+8)/16,(pyry+8)/16);
    }
    //// POWERUP
    if(pupd>0){
    pupd--;
    if(pupd==0)pup=0;
    }
    //// KBD
    if(key[KEY_LEFT]){
        pyrm=2;
    }else if(key[KEY_RIGHT]){
        pyrm=1;
    }else{
        pyrm=0;
    }if(key[KEY_SPACE] & (pyrvy==0
        & (clevel.lblock[pyry/16+1][(pyrx+1)/16]>=0
        | clevel.lblock[pyry/16+1][(pyrx+14)/16]>=0)
        |(pup==1 && pyrvy>=0))){
        pyrvy=-8;
    }if(key[KEY_ENTER]){
        if(clevel.lblock[(pyry+8)/16][(pyrx+24)/16]==1 & pyrom==1){
            clevel.lblock[(pyry+8)/16][(pyrx+24)/16]=-1;
            clevel.vblock[(pyry+8)/16][(pyrx+24)/16]
            =clevel.xblock[(pyry+8)/16][(pyrx+24)/16];           
        }if(clevel.lblock[(pyry+8)/16][(pyrx-8)/16]==1 & pyrom==2){
            clevel.lblock[(pyry+8)/16][(pyrx-8)/16]=-1;
            clevel.vblock[(pyry+8)/16][(pyrx-8)/16]
            =clevel.xblock[(pyry+8)/16][(pyrx-8)/16];
        }
    }
    return 0;
}
//////////////
// Main code
//
int main(int argc, char *argv[]) {
    int i;
    allegro_init();
    install_timer();
    install_keyboard();
    set_color_depth(32);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);
    set_window_title("Kimmy the Little Dungeon Explorer (alpha release 3)");
    
    // Initial stuff
    blah=create_bitmap(320,200);
    tbuf=create_bitmap(16,16);
    tileset=load_pcx("gfx/tileset.pcx",NULL);
    itemset=load_pcx("gfx/itemset.pcx",NULL);
    icons[0]=load_pcx("gfx/lifeicon.pcx",NULL);

    for(i=0;i<256;i++){ctf[i]=i;vctf[i]=i;xctf[i]=i;}
    ctf[32]=0;
    vctf[32]=0;
    level=1;
    clevel=compile_level(level);
    levbak=clevel;
    text_mode(-1);
    lives=3;
    score=0;
    
    // Main App Loop
    gamemode=gm_play;
//    gamemode=100;
    while(gamemode!=gm_quit){
    poll_keyboard();
        switch (gamemode){
        case gm_play:
            gameloop();
            break;
        }
    
    if(key[KEY_ESC]){gamemode=gm_quit;}
    // This REALLY cuts out lag instead of
    // double-calculating clock()-oldclock
    // so then it gets the FPS right.
    newclk=clock()-oldclk;
    if(newclk<20) rest (20-newclk);
    //else printf("NoRest!");
    oldclk=clock();
    }
    return 0;
}
END_OF_MAIN();

