/*
Collision Detection for Evolight
Date:13/12/2001
Last Update: 13/3/2002
By: Dennis Dryden
*/
#include <math.h>

#include "evolight.h"


extern SHIP player;
extern SHIP roids[MAX_ROIDS];


/*
  This function takes the the coords of two objects and returns the 
  distance between them.
*/
int idist(int x1, int y1, int x2, int y2)
{
   int lenx = x1 - x2;
   int leny = y1 - y2;
   int dist;

   dist = (lenx * lenx) + (leny * leny);
   dist = sqrt(dist);
   return dist;
}


/*
  This function uses the dist function to see if two objects are 
  colliding.
*/
int cir_collision_old(int x1, int y1, int size1, int x2, int y2, int size2)
{
   int realsize = 0;
   int dist = idist(x1, y1, x2, y2);

   if (size1 <= size2)
      realsize = size2 - size1;

   if (size2 < size1)
      realsize = size1 - size2;

   if (dist < ((realsize) * (realsize)))
      return 1;
   else
      return 0;
}

int cir_collision(int x1, int y1, int rad1, int x2, int y2, int rad2)
{
   int hit = 0;
   int dist = idist(x1, y1, x2, y2);
   if (dist <= (rad1 + rad2))
      hit = 1;

   return hit;
}

/*Returns 1 on collision and 0 on no collision.*/
int box_collision(int x1, int y1, int w1, int h1, int x2, int y2, int w2,
		  int h2)
{
   /*      IF box2 is in box1...    */
   if ((x1 <= x2) && (y1 <= y2) && (x2 <= x1 + w1) && (y2 <= y1 + h1))
      return 1;

   /*      If box1 is in box2...   */
   if ((x2 <= x1) && (y2 <= y1) && (x1 <= x2 + w2) && (y1 <= y2 + h2))
      return 1;

   return 0;
}


/*This function will...*/
void chk_collisions(void)
{
   int n;
   for (n = 0; n < MAX_ROIDS; n++) {
      if (roids[n].alive == 1) {
	 /*chk for collisions */
	 if (box_collision
	     (player.pos.x, player.pos.y, 64, 64, roids[n].pos.x,
	      roids[n].pos.y, 64, 64) == 1) {
	    /*We hit somthing... now feel the pain!!! */
	    player.health--;
	 }
      }
   }
}



/*******************************************************************/
/***************************OLD functions***************************/
/*******************************************************************/

/*This is the collision detection rutine that i used to use(date: 7/4/2002)*/
void old_chk_collisions(void)
{
   int n;
   for (n = 0; n < MAX_ROIDS; n++) {
      /*chk for collisions */
      if (collision
	  (player.pos.x, player.pos.y, 64, 64, roids[n].pos.x,
	   roids[n].pos.y, 64, 64)) {
	 /*ye what you gona do about it? */
	 player.health -= 10;
      }
   }
}

int
collision(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2)
{
   if (x1 > x2 - w2 && x1 < x2 + w2 && y1 > y2 - h2 && y1 < y2 + h2)
      return 1;
   else
      return 0;
}
