/*Stars
By: Dennis Dryden
*/

/*
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
*/
#include "evolight.h"

/*static STAR stars[MAX_STARS];*/
STAR stars[MAX_STARS];
extern BITMAP *buffer;

//this should place all stars on the screen in random places.
void init_stars(float speed)
{
   int lay_start1 = 0;
   int lay_start2 = 40;
   int lay_start3 = 80;

   int n;
   /*first layer */
   for (n = lay_start1; n <= lay_start2; n++) {
      stars[n].pos.x = (int)(rand() % 640);
      stars[n].pos.y = (int)(rand() % 480);
      stars[n].layer = 1;
      stars[n].speed.x = 0;
      stars[n].speed.y = speed * 1;
      stars[n].col = 190;
   }

   /*2nd layer */
   for (n = lay_start2; n <= (lay_start3 - 1); n++) {
      stars[n].pos.x = (int)(rand() % 640);
      stars[n].pos.y = (int)(rand() % 480);
      stars[n].layer = 2;
      stars[n].speed.x = 0;
      stars[n].speed.y = speed * 2;
      stars[n].col = 100;
   }

   /*3d layer */
   for (n = lay_start3; n < MAX_STARS; n++) {
      stars[n].pos.x = (int)(rand() % 640);
      stars[n].pos.y = (int)(rand() % 480);
      stars[n].layer = 3;
      stars[n].speed.x = 0;
      stars[n].speed.y = speed * 3;
      stars[n].col = 50;
   }
}

//this is to allow the speed of the stars to change.
void star_speed(float speedx, float speedy)
{
   int lay_start1 = 0;
   int lay_start2 = 40;
   int lay_start3 = 80;

   int n;
   /*first layer */
   for (n = lay_start1; n <= lay_start2; n++) {
      stars[n].speed.x = speedx * 1;
      stars[n].speed.y = speedy * 1;
   }
   /*2nd layer */
   for (n = lay_start2; n <= (lay_start3 - 1); n++) {
      stars[n].speed.x = speedx * 2;
      stars[n].speed.y = speedy * 2;
   }
   /*3d layer */
   for (n = lay_start3; n < MAX_STARS; n++) {
      stars[n].speed.x = speedx * 3;
      stars[n].speed.y = speedy * 3;
   }
}

//this function adds there speed to there position.
void move_stars(void)
{
   int n;
   for (n = 0; n < MAX_STARS; n++) {
      stars[n].pos.x += stars[n].speed.x;
      stars[n].pos.y += stars[n].speed.y;
      if (stars[n].pos.x < 0)
	 stars[n].pos.x = 640;
      if (stars[n].pos.x > 640)
	 stars[n].pos.x = 0;
      if (stars[n].pos.y < 0)
	 stars[n].pos.y = 480;
      /*Bellow is the only one realy needed in this game */
      if (stars[n].pos.y > 480)
	 stars[n].pos.y = 0;
   }
}



void draw_stars(void)
{
   int n;
   for (n = 0; n < MAX_STARS; n++) {
      /*putpixel(buffer, stars[n].pos.x, stars[n].pos.y, makecol(stars[n].col, stars[n].col, stars[n].col)); */
      circlefill(buffer, (int)stars[n].pos.x, (int)stars[n].pos.y, 1,
		 makecol(stars[n].col, stars[n].col, stars[n].col));
   }
}
