/***********Roids**********
File: roids.c
By: Dennis Dryden
Date: 7/12/2001 00:05(late night/erly morning ;-)
Last major update: Thu Mar 28 11:58:14 GMT 2002
GNU GPL, see file COPYING.
***************************/

/*
#include <stdio.h>
#include <allegro.h>
*/

#include "evolight.h"



SHIP roids[MAX_ROIDS];
int current_roids;
extern BITMAP *buffer;
extern DATAFILE *gfxdat;

/*
 * This function returns the direction the ship is going.
 * It takes the position in the roid array as an argument.
 */
int get_dir(int n)
{
   /*Set the state to the direction the roid is going. */
   if (n == 0)
      return BANK_CENTER;
   else if (n < 0)
      return BANK_LEFT;
   else if (n > 0)
      return BANK_RIGHT;

   return BANK_CENTER;
}


/*
This function will start some roids falling from random possitions
from the top of the screen.
*/
void init_roids(int num)
{
   int n;
   /*This should stop there being any memory corruptions. */
   if (num > MAX_ROIDS)
      num = MAX_ROIDS;

   /*Kill all the roids */
   for (n = 0; n < MAX_ROIDS; n++) {
      roids[n].alive = 0;
   }

   /*Start the roids */
   for (n = 0; n < num; n++) {
      roids[n].alive = 1;
      roids[n].pos.x = (int)(rand() % 640);
      roids[n].pos.y = 0 - (int)(rand() % 200);
      roids[n].speed.x = 2 - (int)(rand() % 5);
      if (roids[n].speed.x == 0)
	 roids[n].speed.x = 2;

      roids[n].state = get_dir(roids[n].speed.x);

      roids[n].speed.y = 1;	/*Set the downward speed */
      roids[n].health = 20;
   }

   current_roids = num;
}

void add_roids(int num)
{
/*
	This functionGos through the roids list and restarts dead roids agin. It uses "num" to find
	out how many roids to start.
*/
   int n;
   int n2 = 0;
   for (n = 0; (n < MAX_ROIDS) && (n2 < num); n++) {
       /**/ if (roids[n].alive == 0) {
	 n2++;
	 roids[n].alive = 1;
	 roids[n].pos.x = (rand() % 640);
	 roids[n].pos.y = 0 - (int)(rand() % 150);
	 roids[n].speed.x = 2 - (rand() % 5);
	 if (roids[n].speed.x == 0)
	    roids[n].speed.x = -2;

	 /*Set the state to the direction the roid is going. */
/*			if (roids[n].speed.x == 0)
				roids[n].state = BANK_CENT;
			else if (roids[n].speed.x < 0)
				roids[n].state = BANK_LEFT;
			else if (roids[n].speed.x > 0)
				roids[n].state = BANK_RIGHT;
*/

	 roids[n].state = get_dir(roids[n].speed.x);

	 roids[n].speed.y = 1;
	 roids[n].health = 20;
      }
   }
}

void move_roids(void)
{
   /*move all the roids based on there speed values. */
   int n;
   for (n = 0; n < MAX_ROIDS; n++) {
      if (roids[n].alive == 1) {
	 roids[n].pos.x += roids[n].speed.x;
	 roids[n].pos.y += roids[n].speed.y;

	 /*If the rois hits the left or right side make it rebound. */
	 if (roids[n].pos.x < 0) {
	    roids[n].pos.x = 0;
	    roids[n].speed.x = 2;
	    roids[n].state = BANK_RIGHT;
	 }
	 if (roids[n].pos.x > 640 - 64) {
	    roids[n].pos.x = 640 - 64;
	    roids[n].speed.x = -2;
	    roids[n].state = BANK_LEFT;
	 }

	 /*wtf!?!? how coud this happen?
	    if (roids[n].pos.y < 0)
	    roids[n].pos.y = 480;
	  */

	 /*If roids off botom of screen kill it =) */
	 if (roids[n].pos.y > 480) {
	    roids[n].pos.x = 0;
	    roids[n].pos.y = 0;
	    roids[n].alive = 0;
	 }

      }
      else {
	 /*If the roid is dead then it should be moved off screen */
	 roids[n].pos.x = 0;
	 roids[n].pos.y = 0;
      }
   }
}



void draw_roids(void)
{
   int n;
   for (n = 0; n < MAX_ROIDS; n++) {
      if (roids[n].alive == 1) {
	 /*draw the roids */
	 switch (roids[n].state) {
	    case BANK_RIGHT:
	       draw_sprite(buffer, gfxdat[roid].dat, roids[n].pos.x,
			   roids[n].pos.y);
	       break;

	    case BANK_LEFT:
	       draw_sprite_h_flip(buffer, gfxdat[roid].dat, roids[n].pos.x,
				  roids[n].pos.y);
	       break;

	    default:
	       draw_sprite(buffer, gfxdat[roid].dat, roids[n].pos.x,
			   roids[n].pos.y);
	       break;
	 }
	 /*
	    textprintf(buffer, font, roids[n].pos.x - 20, roids[n].pos.y + 64,
	    makecol(150 - n, 40 + (n * 10), 50), " %d ",
	    roids[n].health);
	  */
      }
   }
}

/*This function takes coords and returns the number of the roid that hit.*/
int roid_collision(int x, int y, int mindist)
{
   int dist;
   int n;
   for (n = 0; n < MAX_ROIDS; n++) {
      if (roids[n].alive == 1) {
	 /*chk for collisions */
	 dist = idist(x, y, roids[n].pos.x + 32, roids[n].pos.y + 32);
	 if (dist < mindist) {
	    /*We hit somthing... now feel the pain!!! */
	    return n;
	 }
      }
   }
   return -1;
}


/*This function returns the x value of the requestid roid*/
int get_roid_x(int n)
{
   return roids[n].pos.x;
}

int get_roid_y(int n)
{
   return roids[n].pos.y;
}

void kill_roid(int n)
{
   roids[n].alive = 0;
   roids[n].state = EXPL;
   roids[n].health = 0;
}

int get_roid_health(int n)
{
   return roids[n].health;
}

void damage_roid(int n, int damage)
{
   //ooooch!
   roids[n].health -= damage;
}
