/*
 *	EvoLight.h
 */

//#define USE_FBLEND

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <tdgui.h>

//data file headers...
#include "gfxdat.h"
#include "snddat.h"
#include "titledat.h"
#include "menudat.h"

#define EVOLIGHT_VERSION 1.6

/*define'z for game...*/
#define MAX_STARS 120		/*must be devidable by 3... 3 layers of stars :) */
#define MAX_ROIDS 20
#define MAX_SHOTS 64
#define START_NUM_ROIDS 5
#define DEBUG_MODE
#define MAX_EXPL 40
#define EXPL_LIFE 20
#define MAX_POWERUPS 24

/*Player ship states...*/
#define BANK_LEFT 1
#define BANK_CENTER 2
#define BANK_RIGHT 3
#define EXPL 10

#define POWERUP_HEALTH	0
#define POWERUP_SHOT_DAMAGE	1
#define POWERUP_SCORE_INC	2
#define POWERUP_RAND	3
#define MAX_POWERUP_TYPES 	3	//remember to update

/*structs*/
//typedef struct RGB RGB; /*RGB is defed in pallet.h in allegro*/

typedef struct POS {
   int x;
   int y;
} POS;


/*This is for the shots and other types of stuff*/
typedef struct EVO_FPOS {
   float x;
   float y;
} FPOS;

typedef struct EVO_STAR {
   FPOS pos;
   FPOS speed;
   int layer;
   int col;
} STAR;

typedef struct EVO_SHOT {
   POS pos;
   POS speed;
   int type;
   int damage;
   int alive;
} SHOT;

typedef struct EVO_SHIP {
   POS pos;
   POS speed;
   int state;
   int health;
   int alive;
   int score;
   int shoot;
} SHIP;

typedef struct EVO_POWERUP {
   POS pos;
   POS speed;
   int type;
   int alive;
   int state;
} POWERUP;


/*Extern var'z*/
//extern BITMAP *buffer;


/*function pro'z*/

/*star funk'z*/
void init_stars(float);
void star_speed(float, float);
void move_stars(void);
void draw_stars(void);


/*shot funk'z*/
void init_shots(void);
void shoot(int, int, int, int);
void shoot_up(int, int);
void move_shots(void);
void draw_shots(void);
void alive_shot_coords(int, int);
int shot_collision(void);
void upgrade_shots(int);

/*roid funcs*/
void init_roids(int);
void add_roids(int);
void move_roids(void);
void draw_roids(void);
int roid_collision(int, int, int);
int get_roid_x(int);
int get_roid_y(int);
void kill_roid(int);
int get_roid_health(int);
void damage_roid(int, int);

/*enemy func'z*/
void init_enamy(int);
void move_enamys(void);
void draw_enamys(void);

/*collision*/
int idist(int, int, int, int);
int cir_collision(int, int, int, int, int, int);
int box_collision(int, int, int, int, int, int, int, int);

void chk_collisions(void);

/*Older functions from this file...*/
int collision(int, int, int, int, int, int, int, int);


/*Explotion funkz*/
void init_exp(void);
void add_exp(int, int);
void add_small_exp(int, int);
void update_exps(void);
void draw_exps(BITMAP *);
int get_exp_x(int);
int get_exp_y(int);


/*powerup funcs*/
void init_powerups(void);
void add_powerup(int, int, int, int, int);
void move_powerups(void);
void draw_powerups(void);
int powerup_collision(int, int, int);
int get_powerup_x(int);
int get_powerup_y(int);
void kill_powerup(int);
