/*******************************************/
/* This was my collage project...          */
/*           EvoLight 1.65                 */
/*                                         */
/* This game was made while studying at    */
/* the collage of Weast Anglia in          */
/* Kings Lynn, Norfolk.                    */
/*     Small fix's after ;)                */
/*                                         */
/* Start date: 	Tues 30 Oct 2001           */
/* Last update:	                           */
/* Small bug fix: No recent                */
/* By: Dennis Dryden                       */
/* Web http://evolight.sourceforge.net     */
/* Email: ddryden@graffiti.net             */
/*                                         */
/*******************************************/


#include <stdio.h>
#include <time.h>
#include <allegro.h>
#include <tdgui.h>		//bgui2 header file.

#ifdef USE_FBLEND
#include <fblend.h>
#endif

#include "menudat.h"
#include "evolight.h"

/*
#include "titledat.h"
#include "gfxdat.h"
*/

/*Function Prototypes*/
int playgame(int);		//This is the main game function (funbit :-).

/*Globle Variables*/
BITMAP *buffer;
DATAFILE *gfxdat;
DATAFILE *snddat;
DATAFILE *menudat;
SHIP player;

int fps_count;
int fps;

int color_depth = 0;

/*Sound levels...*/
int digi_volume = 0;
int midi_volume = 0;

volatile int speed_counter = 0;	/*part of the fps counter */
volatile int more_roids = 0;
volatile int more_shots = 0;
volatile int game_time = 0;

/***************************************************************/
/***********************TIMER'z*********************************/
/***************************************************************/

void clean_timers()
{
   speed_counter = 0;
   more_roids = 0;
   more_shots = 0;
   game_time = 0;
   fps = 0;
   fps_count = 0;
}


/*This is another part of the fps counter... the bit that counts up =)*/
void increment_speed_counter()
{
   speed_counter++;
}

END_OF_FUNCTION(increment_speed_counter);


void more_roids_plz()
{
   more_roids++;
}

END_OF_FUNCTION(more_roids_plz);


void more_shots_plz()
{
   if (more_shots < 2)
      more_shots++;
}

END_OF_FUNCTION(more_shots_plz);



/*This function will be called once every second by one of the timers.*/
void game_tick()
{
   game_time++;
   fps = fps_count;
   fps_count = 0;
}

END_OF_FUNCTION(game_tick)


/*******************Sound level functions**********************/
/*This function is called when the GUI slider is moved. It sets 
the volume to the value the slider holds.*/
int change_digi_vol(void *dp3, int lvl)
{
   digi_volume = lvl;
   set_volume(digi_volume, midi_volume);
   play_sample(menudat[digi].dat, 255, 127, 1000, 0);
   return 0;
}

/*This function is called when the GUI slider is moved. It sets 
the volume to the value the slider holds.*/
int change_midi_vol(void *dp3, int lvl)
{
   midi_volume = lvl;
   set_volume(digi_volume, midi_volume);
   return 0;
}

/********************Debug functions***************************/
void drawlines()
{
   int dist;
   int n;
   for (n = 0; n < MAX_EXPL; n++) {
      /*Find the new distance between the player and roid. */
      dist = idist(player.pos.x, player.pos.y, get_exp_x(n), get_exp_y(n));
      /*Draw the line... */
      if (dist > 64) {
	 line(buffer, player.pos.x + 32, player.pos.y + 32,
	      get_exp_x(n) + 32, get_exp_y(n) + 32,
	      makecol((int)dist / 10 * 2, 5 + n * 10, 5));
      }
      else {
	 line(buffer, player.pos.x + 32, player.pos.y + 32,
	      get_exp_x(n) + 32, get_exp_y(n) + 32, makecol(255, 0, 0));
      }
      /*Print the distance */
      textprintf(buffer, font, get_exp_x(n) - 10, get_exp_y(n) - 10,
		 makecol(240, 100, 50), "%i", dist);
   }
}

/*

-= Old Debuging code section: May no longer work due to redundant variables =-
void draw_debug_text(void)
{
   textprintf(buffer, font, 10, 10, makecol(150, 50, 50),
	      "Ship x=%d y=%d timer=%d col_d=%d", player.pos.x,
	      player.pos.y, game_time, color_depth);
   textprintf(buffer, font, 10, 20, makecol(150, 50, 50),
	      "more_roids? %d, Player is hitting: %i", more_roids, hiting);
   textprintf(buffer, font, 5, SCREEN_H - 20, makecol(150, 50, 50),
	      "FPS %i", fps);

   //alive_shot_coords(10, 30);
}
*/


/********************GFX Mode functions...*********************/
void evo_gfx_win(int windowed)
{
   switch (windowed) {
      case 1:
	 if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0) {
	    allegro_message("Sorry could not window the program.");
	    allegro_message("%s", allegro_error);
	    set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
	 }
	 break;

      case 0:
	 if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
	    allegro_message("Sorry couldnt go fullscreen!");
	 break;

   }
}

/****
	The two bellow functions are used as wrappers for the above function(). 
	I have to do this to get the functions to call from my menu dialog.
****/
void evo_gfx_windowed(void)
{
   evo_gfx_win(1);
}

void evo_gfx_fullscreen(void)
{
   evo_gfx_win(0);
}

void evo_box(int x1, int y1, int x2, int y2)
{
   drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
   rectfill(buffer, x1, y1, x2, y2, makecol(0, 200, 10));
   rect(buffer, x1, y1, x2, y2, makecol(255, 0, 0));
   circlefill(buffer, x1, y1, 19, makecol(255, 0, 0));
   circle(buffer, x1, y1, 20, makecol(125, 125, 125));
   circlefill(buffer, x2, y2, 19, makecol(255, 0, 0));
   circle(buffer, x2, y2, 20, makecol(125, 125, 125));
   drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

/*
 * This function will display the names of all the people 
 * responsible for this game(just me then ;-).
 * I also want other cool things to happen in the background
 * or over the name(s).
 */
void complete_message(void)
{
   int x, y;

   int message_num = 0;
   int exit_loop = 0;
   BITMAP *game_screen;

   //i want game_screen to hold the game when it was won.
   game_screen = create_bitmap(SCREEN_W, SCREEN_H);
   blit(buffer, game_screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);


   do {
      clear_bitmap(buffer);

      blit(game_screen, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

      switch (message_num) {
	 case 0:
	    //first create the box behind the text. Makes text more readable.
	    evo_box(20, SCREEN_H / 2 - 10, SCREEN_W - 20,
		    SCREEN_H / 2 + 70);

	    textprintf_centre_ex(buffer, gfxdat[space_font].dat,
				 SCREEN_W / 2, SCREEN_H / 2, makecol(255,
								     0, 0),
				 -1, "Programming by: Dennis Dyden");

	    textprintf_centre_ex(buffer, font, SCREEN_W / 2,
				 SCREEN_H / 2 + 24, makecol(0, 100,
							    180), -1,
				 "Made while studying at Kings Lynn Collage + APU");
	    textprintf_centre_ex(buffer, font, SCREEN_W / 2,
				 SCREEN_H / 2 + 25 * 2, makecol(200, 0, 0),
				 -1, "Press SPACE");
	    break;

	 case 1:
	    evo_box(SCREEN_W / 2 - 150, SCREEN_H / 2 - 10,
		    SCREEN_W / 2 + 110, SCREEN_H / 2 + 90);
	    textprintf_centre_ex(buffer, gfxdat[space_font].dat,
				 SCREEN_W / 2, SCREEN_H / 2, makecol(255,
								     0, 0),
				 -1, "Art by: ");
	    textprintf_centre_ex(buffer, gfxdat[space_font].dat,
				 SCREEN_W / 2, SCREEN_H / 2 + 24,
				 makecol(255, 0, 0), -1, "Dennis Dyden ");
	    textprintf_centre_ex(buffer, font, SCREEN_W / 2,
				 SCREEN_H / 2 + (24 * 2), makecol(0, 120,
								  180), -1,
				 "(+Gimp, PovRay and vi)");

	    textprintf_centre_ex(buffer, font,
				 SCREEN_W / 2, SCREEN_H / 2 + (24 * 3),
				 makecol(200, 0, 0), -1, "Press SPACE");

	    break;

	 case 2:
	    evo_box(30, SCREEN_H / 2 - 10, SCREEN_W - 30,
		    SCREEN_H / 2 + 68);
	    textprintf_centre_ex(buffer, gfxdat[space_font].dat,
				 SCREEN_W / 2, SCREEN_H / 2, makecol(255,
								     0, 0),
				 -1, "EvoLight Web Site:");
	    textprintf_centre_ex(buffer, gfxdat[space_font].dat,
				 SCREEN_W / 2, SCREEN_H / 2 + 24,
				 makecol(0, 0, 255), -1,
				 "http://evolight.sourceforge.net/");

	    textprintf_centre_ex(buffer, font,
				 SCREEN_W / 2, SCREEN_H / 2 + (25 * 2),
				 makecol(200, 0, 0), -1,
				 "Press ESC to Exit");

	    if (key[KEY_ESC])
	       exit_loop = 1;
	    break;
      }

      textprintf_centre_ex(buffer, font, SCREEN_W / 2, SCREEN_H - 24,
			   makecol(0, 100, 255), -1,
			   "Copyright under the GNU GPL, Dennis Dryden 2002");

      if (key[KEY_SPACE]) {
	 message_num++;
	 key[KEY_SPACE] = 0;
	 if (message_num > 2)
	    message_num = 0;
      }

      acquire_screen();
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      release_screen();
   } while (exit_loop != 1);

}


/*This function displays the Game over bar ontop of the game as it was 
when the player dyed.*/
void game_over(int score)
{
   //Set up the blender for transparency...
   set_difference_blender(250, 250, 150, 200);
   /*
      As i would like to have a transparent box behind the game over 
      text(to make it more readable) well change the drawing mode. 
    */
   drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
   rectfill(buffer, (SCREEN_W / 2) - 250, (SCREEN_H / 2) - 20,
	    (SCREEN_W / 2) + 250, (SCREEN_H / 2) + 60, makecol(190, 0, 0));
   /*This set's the drawing mode back to solid insted of transparant. */
   drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
   while (!key[KEY_ESC]) {
      textprintf_centre(buffer, gfxdat[space_font].dat, SCREEN_W / 2,
			SCREEN_H / 2, makecol(255, 255, 255),
			"GAME OVER!!!!");
      textprintf_centre(buffer, gfxdat[space_font].dat, SCREEN_W / 2,
			(SCREEN_H / 2) + 30, makecol(0, 150, 200),
			"Press 'Esc' key to Exit");

      //blit the buffer onto the screen...
      acquire_screen();
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      release_screen();
   }
}



/********************************Main********************************/
int main(int argc, char *argv[])
{
   /*Variables only used in main()... */
   FILE *log_file;		/*This is used to log whats going on in the program */
   DATAFILE *titledat;
   MIDI *menu_music;

   int res_x = 640;
   int res_y = 480;
   //int color_depth = 0;

   /*For the menuing system... */
   int menu_ret;
   int menu_exit = 0;
   int opt_ret;
   int other_ret;

   DIALOG main_dialog[] = {
      /* (proc)            (x)  (y)  (w)  (h)  (fg)   (bg)   (key) (flags) (d1) (d2) (dp)          (dp2) (dp3) */
      {d_shadow_box_proc, 216, 152, 152, 152, 16415, 29582, 0, 0, 0, 0,
       "Main Menu", NULL, NULL},
      {d_button_proc, 248, 200, 88, 30, 64480, 16743, 0, D_EXIT, 0, 0,
       "Start Game", NULL, NULL},
      {d_button_proc, 256, 232, 70, 30, 0, 16743, 0, D_EXIT, 0, 0,
       "Options", NULL, NULL},
      {d_button_proc, 256, 264, 70, 30, 0, 16743, 0, D_EXIT, 0, 0, "Quit",
       NULL, NULL},
      {d_text_proc, 240, 168, 104, 24, 0, 29582, 0, 0, 0, 0, "Main", NULL,
       NULL},
      {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL}
   };
   DIALOG option_dialog[] = {
      /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg)   (key) (flags) (d1) (d2) (dp)       (dp2) (dp3) */
      {d_shadow_box_proc, 192, 136, 176, 176, 0, 29582, 0, 0, 0, 0,
       "Options", NULL, NULL},
      {d_button_proc, 224, 176, 104, 40, 0, 910, 0, D_EXIT, 0, 0, "Sound",
       NULL, NULL},
      {d_button_proc, 224, 216, 104, 40, 0, 910, 0, D_EXIT, 0, 0, "Gfx",
       NULL, NULL},
      {d_button_proc, 224, 264, 104, 40, 0, 910, 0, D_EXIT, 0, 0, "Done",
       NULL, NULL},
      {d_text_proc, 224, 144, 128, 32, 0, 29582, 0, 0, 0, 0, "Options",
       NULL,
       NULL},
      {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL}
   };
   DIALOG sound_dialog[] = {
      /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg)   (key) (flags) (d1) (d2) (dp)            (dp2)             (dp3) */
      {d_shadow_box_proc, 168, 160, 300, 136, 0, 29582, 0, 0, 0, 0,
       "Sound Levels", NULL, NULL},
      {d_slider_proc, 188, 200, 256, 12, 255, 29582, 0, 0, 255, 0, NULL,
       &change_digi_vol, NULL},
      {d_slider_proc, 188, 224, 256, 10, 255, 29582, 0, 0, 255, 0, NULL,
       &change_midi_vol, NULL},
      {d_button_proc, 348, 248, 70, 30, 0, 29127, 0, D_EXIT, 0, 0, "OK",
       NULL, NULL},
      {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL}
   };

   DIALOG gfx_dialog[] = {
      /* (proc)            (x)  (y)  (w)  (h)  (fg) (bg)   (key) (flags)     (d1) (d2) (dp)            (dp2) (dp3) */
      {d_shadow_box_proc, 208, 168, 280, 184, 0, 29582, 0, 0, 0, 0,
       "Gfx Settings", NULL, NULL},
      {d_button_proc, 216, 200, 96, 40, 0, 64300, 0, D_EXIT, 0, 0,
       "Fullscreen", NULL, NULL},
      {d_button_proc, 216, 248, 96, 40, 0, 64300, 0, D_EXIT, 0, 0,
       "Windowed", NULL, NULL},
      {d_textbox_proc, 328, 192, 144, 144, 0, 46518, 0, D_DISABLED, 0, 0,
       "Use These buttons to change the gfx mode. The Windowed option may not work for every one (it would be kinda hard to do in DOS ;-).",
       NULL, NULL},
      {d_button_proc, 216, 304, 80, 32, 0, 64300, 0, D_EXIT, 0, 0, "Done",
       NULL, NULL},
      {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
      {d_button_proc, 216, 304, 80, 32, 0, 0, 0, D_EXIT, 0, 0, "Done",
       NULL, NULL},
      {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
   };

   puts("Evolight: \n");
   puts("Using:");
   puts(" + Allegro");

   /*
      This will open the file that ill be using as a logfile.
      MUST REMEMBER TO CLOSE THIS FILE BE4 EXITING
    */
   if ((log_file = fopen("running-log.txt", "w")) == NULL)
      printf
	  ("Shit well i guess it just couldnt be done... :\nLog file not opened");
   fputs("Opened the file for loging\n", log_file);


	/*******For the timer's**************/
   LOCK_VARIABLE(speed_counter);
   LOCK_FUNCTION(increment_speed_counter);
   LOCK_VARIABLE(more_roids);
   LOCK_FUNCTION(more_roids_plz);
   LOCK_VARIABLE(game_time);
   LOCK_FUNCTION(game_tick);
   LOCK_VARIABLE(more_shots);
   LOCK_FUNCTION(more_shots_plz);

   puts("Starting Allegro...");
   fputs("Starting allegro\n", log_file);
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   /*Setup the sound */
   /* install a digital sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      allegro_message("Error initialising sound system\n%s\n",
		      allegro_error);
      fprintf(log_file, "Error initialising sound system\n%s\n",
	      allegro_error);
   }

   //now set the volume of the sounds...
   set_volume(150, 130);

   /*Set up gfx */
   /*I'm getting errors about this line(13/3/2002). No problem i think(17/10/2002) */
   puts("Setting up GFX...");

   //when the game is minimalized stop all drawing functions... 
   set_display_switch_mode(SWITCH_PAUSE);

   /*
      Not many ppl know this but alot of gfx card support 15 OR 16 bit gfx modes not both.
      so its best to try both not just give up when allegro says "Nope no 16bit gfx
      for you." If they both fail then stop the program and tell the user why the program
      stopped.
    */
   color_depth = 16;
   fprintf(log_file, "Setting up gfx mode...\nColor Depth: %i\n",
	   color_depth);
   set_color_depth(color_depth);
   if (set_gfx_mode(GFX_AUTODETECT, res_x, res_y, 0, 0) != 0) {
      /*Well if it wouldny do 16bpp full screen maybe windowed?.. */
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, res_x, res_y, 0, 0) != 0) {
	 color_depth = 15;
	 set_color_depth(color_depth);
	 fprintf(log_file, "Color Depth: %i\n", color_depth);
	 if (set_gfx_mode(GFX_AUTODETECT, res_x, res_y, 0, 0) != 0) {
	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	    allegro_message("Could not set Screen Mode!\n");
	    return 1;
	 }
      }
   }

   text_mode(-1);		/*This gives the text a transparent background (soon to be gone) */
   drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);	//lets putpixle and stuff work

   buffer = create_bitmap(SCREEN_W, SCREEN_H);	//set up the screen buffer
   if (!buffer) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Cant set up screen buffer, sorry.");
      return 1;
   }

   fprintf(log_file,
	   "Screen Buffer set up at a size of %d x %d'ish\n", res_x,
	   res_y);

   //Load Title data. This pack contains the title screen gfx & music
   titledat = load_datafile("title.dat");
   if (!titledat) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Could not find title.dat");
      return 1;
   }

   /*Copy the title pic(title1) to the buffer */
   draw_sprite(buffer, titledat[title].dat, 0, 0);
   blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

   textout_centre(screen, font, "Loading...", SCREEN_W / 2, SCREEN_H / 2,
		  makecol_depth(color_depth, 0, 0, 0));

   //Load Title data. This pack contains the title screen gfx & music
   gfxdat = load_datafile("gfx.dat");
   if (!gfxdat) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Could not find gfx.dat");
      return 1;
   }
   //Load Sound data. This pack contains the music + sounds.
   snddat = load_datafile("snd.dat");
   if (!snddat) {
      /*If there is no sound then there is no major problem. */
      allegro_message("Could not find snd.dat");
      return 1;
   }

   /* load the datafile */
   menudat = load_datafile("menu.dat");
   if (!menudat) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error loading menu.dat!\n");
      return 1;
   }

   /*Play some music while browsing the menu and have it loop */
   menu_music = load_midi("sound/gamemusic.mid");
   play_midi(menu_music, 1);

   /*--- Do the dialog menuing loop. ---*/
   while (menu_exit == 0) {
      //put the background on the screen.
      drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
      blit(menudat[menubkg].dat, screen, 0, 0, 0, 0, 640, 480);

      set_trans_blender(0, 0, 0, 250);
      drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);

      menu_ret = do_dialog(main_dialog, 1);
      if (menu_ret == 1) {
	 playgame(3);
	 stop_midi();
      }

      if (menu_ret == 2) {
	 menu_ret = 0;
	 opt_ret = 0;
	 opt_ret = do_dialog(option_dialog, 1);
	 if (opt_ret == 1) {
	    do_dialog(sound_dialog, -1);
	 }
	 if (opt_ret == 2) {
	    other_ret = do_dialog(gfx_dialog, -1);
	    if (other_ret == 1)
	       evo_gfx_win(0);	//fullscreen
	    if (other_ret == 2)
	       evo_gfx_win(1);	//windowed       
	 }
      }

      if (menu_ret == 3)
	 menu_exit = 1;
   }

   /*--- Shutdown and unload everything. ---*/

   /*Free memory and close the data files */
   destroy_bitmap(buffer);
   unload_datafile(titledat);
   unload_datafile(gfxdat);
   unload_datafile(snddat);
   unload_datafile(menudat);

   allegro_exit();

   fputs("Thats all folks\n", log_file);
//   fputc(EOF, log_file);      cant remember why i did this but i shouldnt.
   fclose(log_file);

   return 0;
}

END_OF_MAIN()


int playgame(int start_game_level)
{
   MIDI *game_music;

   /*Score information */
   int time_score = 0;
   int shot_score = 0;

   int hiting;
   int win_game = 0;		//You've won the game when this != 0 ;)

   int game_level = start_game_level;

   game_time = 0;
   more_roids = 0;
   more_shots = 0;


   /*Set it all up... */
   init_stars(1.8);		//start stars with a speed of 1.8
   init_shots();		//reset all the shots.
   init_powerups();		//reset all the powerups
   upgrade_shots(10);		//set the damage a shot will do.

   //Set the player up.
   player.pos.x = SCREEN_W / 2 - 16;
   player.pos.y = 400;
   player.speed.x = 0;
   player.speed.y = 0;
   player.state = BANK_CENTER;
   player.health = 100;
   player.alive = 1;
   player.score = 0;
   player.shoot = 0;

   /*Starting the game... */
   init_roids(3);		//resets all roids and stars 3 of them.
   init_exp();			//resets the explosions.

   /*I think this is kinda needed... */
   clean_timers();		//resets the varables used in the timers to 0.

   /*Starting the timer's... */
   install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
   install_int_ex(more_roids_plz, SECS_TO_TIMER(10));
   install_int_ex(game_tick, SECS_TO_TIMER(1));
   install_int_ex(more_shots_plz, BPS_TO_TIMER(6));

   /*Start playing the background midi music... */
   game_music = load_midi("sound/lithium.mid");
   play_midi(game_music, 1);

   do {
      while (speed_counter > 0) {
	 /*All movment code go's in this bit from v to ... */
	 player.state = BANK_CENTER;	//Reset the players state

	 //(ill have to add joystick support to this game some time soon).
	 if (key[KEY_RIGHT]) {
	    player.pos.x += 2;
	    player.state = BANK_RIGHT;
	 }

	 if (key[KEY_LEFT]) {
	    player.pos.x -= 2;
	    player.state = BANK_LEFT;
	 }
	 //move the player up/down with arrow keys
	 if (key[KEY_UP])
	    player.pos.y--;

	 if (key[KEY_DOWN])
	    player.pos.y++;

	 /*If the player is off screen put them back in it... */
	 if (player.pos.x < 0)
	    player.pos.x = 0;
	 if (player.pos.x > SCREEN_W - 64)
	    player.pos.x = SCREEN_W - 64;
	 if (player.pos.y < 0)
	    player.pos.y = 0;
	 if (player.pos.y > SCREEN_H - 64)
	    player.pos.y = SCREEN_H - 64;

	 /*Shoot!!! */
	 if (key[KEY_SPACE]) {
	    if (more_shots >= 1) {
	       play_sample(snddat[shot].dat, 100, 127, 1000, 0);
	       shoot(player.pos.x + 32, player.pos.y + 5, 0, -4);
	       more_shots -= 1;
	    }
	 }

	 /*The below code was used to debug and test the program */
	 //if(key[KEY_S])
	 //   stoproids=1;

	 /*The below code was used to debug and test the program */
	 //if(key[KEY_M])
	 //      more_roids_plz();

	 /*Almost as good as up,down,left,right!! ;) */
	 if (key[KEY_C])
	    win_game = 1;

	 if (key[KEY_S]) {
	    save_bmp("screen_shot.bmp", buffer, NULL);
	    key[KEY_S] = 0;
	 }

	 if (key[KEY_W]) {
	    evo_gfx_win(1);
	    key[KEY_W] = 0;
	    //clear_keybuf();
	 }

	 if (key[KEY_E]) {
	    evo_gfx_win(0);
	    key[KEY_E] = 0;
	 }

	 update_exps();
	 move_powerups();
	 move_stars();
	 move_roids();
	 move_shots();

	 /*
	  *   This _collision function returns the number of the roid that has collided
	  *   or -1 if no collision.
	  */
	 hiting = roid_collision(player.pos.x + 32, player.pos.y + 32, 64);
	 if (hiting != -1) {
	    player.health -= 10;
	    draw_rle_sprite(buffer, gfxdat[exp1].dat,
			    get_roid_x(hiting), get_roid_y(hiting));

	    play_sample(snddat[bang].dat, 255, 127, 1000, 0);

	    add_exp(get_roid_x(hiting), get_roid_y(hiting));
	    kill_roid(hiting);
	 }

	 /*   
	  *   This _collision function works differently, it returns the type of powerup
	  *   or -1 if not hitting anything. Also this function automaticaly kills the 
	  *   powerup thats been hit.
	  */
	 hiting =
	     powerup_collision(player.pos.x + 32, player.pos.y + 32, 48);
	 switch (hiting) {
	    case POWERUP_HEALTH:
	       if (player.health < 75) {
		  player.health += 5;
		  if (player.health > 75)
		     player.health = 75;
	       }
	       break;

	    case POWERUP_SHOT_DAMAGE:
	       upgrade_shots(5);
	       break;

	    case POWERUP_SCORE_INC:
	       shot_score += 150;
	       break;

	    case POWERUP_RAND:
	       switch (rand() % 1) {
		  case 0:
		     shot_score += 150;
		     break;
		  case 1:
		     if (player.health < 75) {
			player.health += 5;
			if (player.health > 75)
			   player.health = 75;
		     }
	       }


	 }

	 shot_score += shot_collision();

	 speed_counter--;
	 /*...to this bit ^ =) */
      }


      if (more_roids > 0) {
	 /*add some roids */
	 add_roids(3 + game_level);
	 more_roids--;
      }


      /*This makes the score go up based on how long the player lives. */
      time_score = game_time * 10;

      /*The players score gos up based on the time score and shot score */
      player.score = time_score + shot_score;

      /*
         This adds more roids at sertain times in the game... making it
         progresivly harder.
       */
      if (player.score >= 1000 && game_level <= 20)
	 game_level = (int)player.score / 1000;

      if (player.score > 15000)
	 /*The game is over!!! You have completed the game. */
	 win_game = 1;

      /*Drawing everything... first to the buffer then the buffer to screen */

      clear(buffer);		//Clear the buffer.
      draw_stars();
      draw_powerups();
      //drawlines();    //This was used for debuging
      draw_roids();
      draw_shots();

      if (player.state == BANK_LEFT)
	 draw_sprite(buffer, gfxdat[ship_l].dat, player.pos.x,
		     player.pos.y);
      if (player.state == BANK_CENTER)
	 draw_sprite(buffer, gfxdat[ship_c].dat, player.pos.x,
		     player.pos.y);
      if (player.state == BANK_RIGHT)
	 draw_sprite(buffer, gfxdat[ship_r].dat, player.pos.x,
		     player.pos.y);

      draw_exps(buffer);

      textprintf(buffer, font, 5, SCREEN_H - 20, makecol(150, 50, 50),
		 "FPS %i", fps);

      textprintf(buffer, gfxdat[space_font].dat, 10, 10,
		 makecol(150, 50, 50), "Score: %i", player.score);

      //Set up the translucency...
      set_trans_blender(0, 0, 0, 98);
      drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
      rectfill(buffer, 395, 8, 395 + 200, 38, makecol(30, 200, 120));

      drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
      rectfill(buffer, 395, 8, 395 + (player.health * 2), 38,
	       makecol(0, 190, 0));
      rect(buffer, 395, 8, 395 + (200), 38, makecol(0, 190, 100));
      textprintf(buffer, gfxdat[space_font].dat, 400, 10,
		 makecol(150, 50, 50), "Health %i", player.health);


      /*
         This (acquire_screen) must be called befor any drawing to the screen 
         on some platforms(speeds up win32 gfx).
       */
      acquire_screen();
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      release_screen();		/*This must then be called after drawing to the screen */

      fps_count++;		//Part of the game timeing.
   }
   while ((!key[KEY_ESC]) && (player.health > 0) && (win_game == 0));

   clear_keybuf();		/*Clear any key presses that are buffered or still being held down. */

   /*If the player has dyed then display a game over screen. */
   if (player.health <= 0) {
      game_over(player.score);
   }

   /*If the player has 'win_game' then show a nice Winning screen */
   if (win_game != 0) {
      complete_message();
   }

   clear_keybuf();

   //clear stuff up...

   /*stoping the timer's... */
   remove_int(increment_speed_counter);
   remove_int(more_roids_plz);
   remove_int(game_tick);
   remove_int(more_shots_plz);

   return 0;
}
