/*Shot functions
By: Dennis Dryden
Date: 29/11/2001
GNU GPL so read COPYING in root of this package. 
*/

/*
	Shots have two different positions held in there struct; a integer position
	and a float position. Becose the shots can be going off in any angle/direction
	this means that there co-ords will enevetibly be floating piont numbers. This
	is a problem however as there is no such thing as a floating point screen
	position(how can i draw on only halth a pixel?? :P ). So to solve this problem
	i will have the movment updater move the shot and then translate the real(float)
	position of the shot to its screen position(interger).

	EDIT:
	A beter way i think... Why not round the numbers when i need them to be round ;)
	like in the call to draw somthing or other just round it in the function call.
	e.g.
		draw(roundf(float), roundf(float));
*/

#include <math.h>

#include "evolight.h"

extern BITMAP *buffer;
extern DATAFILE *snddat;

SHOT pshot[MAX_SHOTS];

/*
	Returns the shot[n]'s x co-ord
*/
int get_shot_x(int n)
{
   return pshot[n].pos.x;
}


/*
	Returns the shot[n]'s y co-ord
*/
int get_shot_y(int n)
{
   return pshot[n].pos.y;
}

int get_shot_alive(int n)
{
   return pshot[n].alive;
}

/*
	Kills the shot
*/
void kill_shot(int n)
{
   pshot[n].alive = 0;
}


void init_shots(void)
{
   /*This function will go through the array of shots and set them to 0 */
   int n;
   for (n = 0; n < MAX_SHOTS; n++) {
      pshot[n].alive = 0;
      pshot[n].pos.x = 0;
      pshot[n].pos.y = 0;
      pshot[n].speed.x = 0;
      pshot[n].speed.y = 0;
      pshot[n].damage = 0;
   }
}

void upgrade_shots(int new_damage)
{
   /*
      This function will move throught the shot array one element at a 
      time and update the shots damage.
    */
   int n;
   for (n = 0; n < MAX_SHOTS; n++) {
      pshot[n].damage += new_damage;
   }
}


void alive_shot_coords(int x, int y)
{
/***** This was a debug function a long time ago. ******************
	int n;
	int amount_alive;	//This is needed to position the printing correctly.
	for (n=0; n < MAX_SHOTS; n++){
		if (pshot[n].alive == 1){
			textprintf(buffer, font, x, y+(amount_alive*10), makecol(0, 240, 0), "Shots %i alive: x = %i, y = %i", n, pshot[n].pos.x, pshot[n].pos.y);
			amount_alive++;
		}
	}
********************************************************************/
}



/*
	This will start a shot with the direction/speed values of dirx and diry
*/
void shoot(int x, int y, int dx, int dy)
{
   int n;
   int exit = 0;
   for (n = 0; (n < MAX_SHOTS) && (exit != 1); n++) {
      if (pshot[n].alive != 1) {
	 /*If the shot is dead... */
	 pshot[n].alive = 1;	/*Set the shot as alive. */
	 pshot[n].pos.x = x;	/*Set the real position. */
	 pshot[n].pos.y = y;
	 pshot[n].speed.x = dx;	/*Set the direction/speed. */
	 pshot[n].speed.y = dy;
	 exit = 1;
      }
   }
}


void shoot_up(int x, int y)
{
   shoot(x, y, 0, -2);
}

/*
	This function moves the shots and updates there integer position.
*/
void move_shots(void)
{
   int n;
   for (n = 0; n < MAX_SHOTS; n++) {
      if (pshot[n].alive == 1) {
	 /*Move the shot by adding its speed to its position. */
	 pshot[n].pos.x += pshot[n].speed.x;
	 pshot[n].pos.y += pshot[n].speed.y;

	 /*Check for off screen ness :) */
	 if (pshot[n].pos.x < 0)
	    pshot[n].alive = 0;

	 if (pshot[n].pos.x > 640)
	    pshot[n].alive = 0;

	 if (pshot[n].pos.y < 0)
	    pshot[n].alive = 0;

	 if (pshot[n].pos.y > 480)
	    pshot[n].alive = 0;

	 /*Translate real position to screen position. */
	 //pshot[n].spos.x = roundf(pshot[n].pos.x);
	 //pshot[n].spos.y = roundf(pshot[n].pos.y);

      }
      /*else{
         pshot[n].pos.x = 0;
         pshot[n].pos.y = 0;
         } */
   }
}


/*
	Draw the shots to the screen.
*/
void draw_shots(void)
{
   int n;
   for (n = 0; n < MAX_SHOTS; n++) {
      if (pshot[n].alive == 1) {
	 /*Well if its alive then why not draw it... */
	 circlefill(buffer, pshot[n].pos.x, pshot[n].pos.y, 3,
		    makecol(255 - (pshot[n].damage * 2),
			    1 + pshot[n].damage, 1));
	 circle(buffer, pshot[n].pos.x, pshot[n].pos.y, 3,
		makecol(1, 50 + (pshot[n].damage * 2),
			20 + pshot[n].damage));
      }
   }
}

/* 
 * This function will find a collision bettween a shot and a roid.
 * On getting this hit it will remove health from the roid. If the 
 * roids health go's below 0 after the hit then the roid is killed 
 * and the player recives more points.
 */
int shot_collision(void)
{
   int n;
   int hiting;
   int score = 0;
   for (n = 0; n < MAX_SHOTS; n++) {
      if (pshot[n].alive == 1) {
	 hiting = roid_collision(pshot[n].pos.x, pshot[n].pos.y, 33);
	 if (hiting != -1) {
	    score = 50;
	    pshot[n].alive = 0;
	    add_small_exp(get_roid_x(hiting), get_roid_y(hiting));
	    play_sample(snddat[bang].dat, 100, 127, 1000, 0);
	    damage_roid(hiting, pshot[n].damage);
	    if (get_roid_health(hiting) <= 0) {
	       //kill it and maybe start a powerup.
	       score += 100;
	       add_exp(get_roid_x(hiting), get_roid_y(hiting));
	       if (rand() % 5 == 1)
		  add_powerup(get_roid_x(hiting), get_roid_y(hiting), 0, 1,
			      rand() % MAX_POWERUP_TYPES);
	       kill_roid(hiting);
	    }
	 }
      }
   }
   return score;
}
