/***********************************************
	powerups.c
	By: Dennis Dryden
	Date Started: December 29, 2002
	GNU GPL
***********************************************/

#include "evolight.h"

POWERUP powerups[MAX_POWERUPS];
int current_powerups;
extern BITMAP *buffer;
extern DATAFILE *gfxdat;

/*powerup funcs*/

/*This function resets the powerups.*/
void init_powerups(void)
{
   int n;
   for (n = 0; n < MAX_POWERUPS; n++) {
      powerups[n].alive = 0;
      powerups[n].pos.x = 0;
      powerups[n].pos.y = 0;
      powerups[n].speed.x = 0;
      powerups[n].speed.y = 0;
      powerups[n].type = 0;
      powerups[n].state = 0;
   }
}


void add_powerup(int x, int y, int sx, int sy, int type)
{
   int n;
   int exit = 0;		//used to exit the loop.

   for (n = 0; n < MAX_POWERUPS && exit != 1; n++) {
      if (powerups[n].alive != 1) {
	 exit = 1;
	 powerups[n].alive = 1;
	 powerups[n].pos.x = x;
	 powerups[n].pos.y = y;
	 powerups[n].speed.x = sx;
	 powerups[n].speed.y = sy;
	 powerups[n].type = type;
      }
   }
}

void move_powerups(void)
{
   int n;
   for (n = 0; n < MAX_POWERUPS; n++) {
      if (powerups[n].alive == 1) {
	 powerups[n].pos.x += powerups[n].speed.x;
	 powerups[n].pos.y += powerups[n].speed.y;

	 powerups[n].state++;
	 if (powerups[n].state > 10)
	    powerups[n].state = 0;

	 if (powerups[n].pos.x + 32 > SCREEN_W) {
	    powerups[n].pos.x = SCREEN_W - 32;
	    powerups[n].speed.x = -1;
	 }
	 if (powerups[n].pos.x < 0) {
	    powerups[n].pos.x = 0;
	    powerups[n].speed.x = 1;
	 }

	 if (powerups[n].pos.y > SCREEN_H || powerups[n].pos.y < 0)
	    powerups[n].alive = 0;

      }
   }
}

void draw_powerups(void)
{
   int linen;

   int n;
   for (n = 0; n < MAX_POWERUPS; n++) {
      if (powerups[n].alive == 1) {

	 // draw_sprite(buffer, (BITMAP *) gfxdat[POWERUP_PIC].dat, powerups[n].pos.x, powerups[n].pos.y);

	 switch (powerups[n].type) {
	    case POWERUP_SCORE_INC:
	       circlefill(buffer, powerups[n].pos.x + 16,
			  powerups[n].pos.y + 16, 16, makecol(0,
							      50 +
							      powerups[n].
							      state * 3,
							      255));
	       circle(buffer, powerups[n].pos.x + 16,
		      powerups[n].pos.y + 16, powerups[n].state + 6,
		      makecol(16, 64, 150));
	       textprintf_ex(buffer, gfxdat[space_font].dat,
			     powerups[n].pos.x + 9, powerups[n].pos.y + 4,
			     makecol(255, 200,
				     (int)powerups[n].state * 2.5), -1,
			     "$");
	       break;

	    case POWERUP_SHOT_DAMAGE:
	       draw_sprite(buffer, (BITMAP *) gfxdat[powerup_shot].dat,
			   powerups[n].pos.x, powerups[n].pos.y);
	       break;

	    case POWERUP_HEALTH:
	       circlefill(buffer, powerups[n].pos.x + 16,
			  powerups[n].pos.y + 16, 16, makecol(255, 255,
							      255));
	       for (linen = 0; linen < 6; linen++) {
		  line(buffer, powerups[n].pos.x,
		       powerups[n].pos.y + 14 + linen,
		       powerups[n].pos.x + 32,
		       powerups[n].pos.y + 14 + linen,
		       makecol(255 - powerups[n].state * 10, 0, 0));
		  line(buffer, powerups[n].pos.x + 13 + linen,
		       powerups[n].pos.y, powerups[n].pos.x + 13 + linen,
		       powerups[n].pos.y + 32,
		       makecol(255 - powerups[n].state * 10, 0, 0));
	       }
	       break;

	    default:
	       draw_sprite(buffer, (BITMAP *) gfxdat[powerup_base].dat,
			   powerups[n].pos.x, powerups[n].pos.y);
	       break;		//not very needed as at end.    
	 }
	 //debug bits...
	 /*
	    textprintf_ex(buffer, font, powerups[n].pos.x,
	    powerups[n].pos.y + 32, makecol(0, 255, 0), -1,
	    "%i", powerups[n].type);
	    textprintf_ex(buffer, font, powerups[n].pos.x + 32,
	    powerups[n].pos.y, makecol(255, 0, 0), -1, "%i", n);
	  */
      }
   }
}

/* 
 *   This function takes coords and returns the number of the powerup that 
 *   hit, or return -1.
 */
int powerup_collision(int x, int y, int mindist)
{
   int dist;
   int n;
   for (n = 0; n < MAX_POWERUPS; n++) {
      if (powerups[n].alive == 1) {
	 /*chk for collisions */
	 dist =
	     idist(x, y, powerups[n].pos.x + 16, powerups[n].pos.y + 16);
	 if (dist < mindist) {
	    /*We hit somthing... now feel the pain!!! */
	    powerups[n].alive = 0;
	    return powerups[n].type;
	 }
      }
   }
   return -1;			//this means no it isnt a collision.
}


int get_powerup_x(int n)
{
   return powerups[n].pos.x;
}

int get_powerup_y(int n)
{
   return powerups[n].pos.y;
}

void kill_powerup(int n)
{
   powerups[n].alive = 0;
}
