#include "config.h"
#include <stdio.h>
#include <string.h>
#include <allegro.h>
#ifndef _WIN32
#  include <pwd.h>
#  include <sys/stat.h>
#  include <sys/types.h>
#endif
#include "qfe.h"
#include "domin.h"
#include "dsound.h"
#include "domin_ai.h"
#ifdef USE_DUMB
#  include <dumb.h>
#  define MIDISUBST(mod,midi) mod
#  define IFDUMB(args...) args
#else
#  define MIDISUBST(mod,midi) midi
#  define IFDUMB(args...)
#endif


extern int carddrop; extern BITMAP *buffer;

static char *startupplayernames[] = {
    "nobody", "Etawg", "Fat Weasel", "Master Wo", "Zorage", "Big Nate", "Dr K", "Black Chris"
};

int ok_adime(DIALOG *d, int n) {
	return -1;
}

static void my_adime_callback(DIALOG *d) {
	check_sound();
	check_screen_shot();
}



void getstartupvals() {
    adime_callback = my_adime_callback;
#ifdef _WIN32
    set_config_file("domin.cfg");
#else
    passwd *pwp;
    char cfgname[200];
    if ( ( pwp = getpwuid(getuid()) ) ) {
       snprintf(home_dir, sizeof home_dir, "%s/.domin/", pwp->pw_dir);
       mkdir(home_dir, 0755);
    }
    snprintf(cfgname, sizeof cfgname, "%sdomin.cfg", home_dir);
    set_config_file(cfgname);
#endif
    for (int who = 0; who <= maxplayers; who++) {
      char playername[20], playerai[20];
      snprintf(playername, sizeof playername, "player%i_name", who);
      snprintf(playerai, sizeof playerai, "player%i_ai", who);
      strncpy(player[who].name, get_config_string("main", playername,
      	#ifdef _WIN32
	startupplayernames[who]
	#else
	(who == 1 ? pwp->pw_name : startupplayernames[who])
	#endif
	), sizeof player[who].name);
      player[who].ai_var = get_config_int("main", playerai, 0);
    }
    numplayers = get_config_int("main", "num_players", 2);
    numsq = get_config_int("main", "board_size", 6);
    piecesowned = get_config_int("main", "hand_size", 3);
    ai_test  = get_config_int("main", "ai_test", 0);
    ai_wait_timing = get_config_int("main", "ai_wait_timing", 1800);
    fast_spinner = get_config_int("main", "fast_spinner", 0);
    strncpy(data_dir, get_config_string("main", "data_dir", DATA_DIR), sizeof data_dir);
    strncpy(scr_shot_dir, get_config_string("main", "scr_shot_dir", home_dir), sizeof scr_shot_dir);
    strncpy(music_dir, get_config_string("main", "music_dir", home_dir), sizeof music_dir);
    strncpy(songtab[GM_DEFAULT], get_config_string("main","default_song", MIDISUBST("main.it","wasted.mid")), sizeof songtab[0]);
    strncpy(songtab[GM_TITLE], get_config_string("main","title_song", MIDISUBST("main.it","wasted.mid")), sizeof songtab[0]);
    strncpy(songtab[GM_CREDITS], get_config_string("main","credits_song", MIDISUBST("wasted.it","wasted.mid")), sizeof songtab[0]);
    strncpy(songtab[GM_WIN], get_config_string("main","win_song", MIDISUBST("win.it","wasted.mid")), sizeof songtab[0]);
    strncpy(songtab[GM_LOSE], get_config_string("main","lose_song", MIDISUBST("lose.it","wasted.mid")), sizeof songtab[0]);
#ifdef USE_DUMB
    dumb_resampling_quality = get_config_int("main", "music_resampling_quality", DUMB_RQ_CUBIC );
    music_freq = get_config_int("main", "music_freq",  44100);
    music_buffer_size = get_config_int("main", "music_buffer_size",  1024 * 6);
#endif
    enable_sound  = get_config_int("main", "enable_sound", 1);
    enable_music  = get_config_int("main", "enable_music", 1);
    sound_vol  = get_config_int("main", "sound_vol", 127);
    music_vol  = get_config_int("main", "music_vol", 60);

    default_screen_w = get_config_int("main", "screen_w", 640);
    default_screen_h = get_config_int("main", "screen_h", 480);
    prefer_windowed = get_config_int("main", "windowed", 0);
    printf("got startup values\n");
}


int sound_options_dlg(DIALOG *d) {
   int graphics_mode_index = (default_screen_w == 800 ? 1 : default_screen_w == 1024 ? 2 : 0);
   int old_gmx = graphics_mode_index;
   int old_windowed = prefer_windowed;
#ifdef USE_DUMB
   int mfreq_list[] = {8000,11025,22050,44100};
   int freq_index = (
       music_freq >= mfreq_list[3] ? 3  :
       music_freq >= mfreq_list[2] ? 2  :
       music_freq >= mfreq_list[1] ? 1  : 0
   );
   int old_fi  = freq_index;
   int old_mbs = music_buffer_size;
#endif
   int res = adime_dialogf(
                    "Video/Sound Options",
                    ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 160,
                    "Graphics mode:%list[,640x480;800x600;1024x768]"
                    "Windowed:%bool[]"
                    "%line[]"
                    "AI Wait (ms):%pint[0,5000]"
                    "Fast Spinner:%bool[]"
                    "%line[]"
                    "SFX Volume [0-255]:%pint[0,255]"
                    "Allow SFX:%bool[]"
                    "Music Volume [0-255]:%pint[0,255]"
                    "Allow Music:%bool[]"
            IFDUMB(
                    "%line[]"
                    "Advanced Sound:%nothing[]"
                    "Resample Quality: %list[,Poor;Normal;High]"
                    "Music Freq: %list[,8000;11025;22050;44100]"
                    "Music Buffer (bytes): %pint[1000,1000000]"
            )
                    ,
                    &graphics_mode_index,
                    &prefer_windowed,
                    &ai_wait_timing,
                    &fast_spinner,
                    &sound_vol,
                    &enable_sound,
                    &music_vol,
                    &enable_music
            IFDUMB(
                    ,
                    &dumb_resampling_quality,
                    &freq_index,
                    &music_buffer_size
            )
   );
   if (old_gmx != graphics_mode_index ||  old_windowed != prefer_windowed) {
   	switch (graphics_mode_index) {
        case 0: default_screen_w =  640; default_screen_h = 480; break;
        case 1: default_screen_w =  800; default_screen_h = 600; break;
        case 2: default_screen_w = 1024; default_screen_h = 768; break;
        }
        if ( set_gfx_mode(
        	( prefer_windowed ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT),
        	default_screen_w, default_screen_h, 0, 0) < 0 &&
             set_gfx_mode(
        	( prefer_windowed ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT),
        	( default_screen_w = 640), (default_screen_h = 480 ), 0, 0) < 0
	)   {
		 allegro_message( "Could not set video mode. Reason: %s\n", allegro_error );
	} else {
		if (old_gmx != graphics_mode_index) reinit_graphics();
 		else blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
                set_config_int("main", "screen_w", default_screen_w );
                set_config_int("main", "screen_h", default_screen_h );
                set_config_int("main", "windowed", ( prefer_windowed ? 1 : 0));
        }
   }
#ifdef USE_DUMB
   set_config_int("main", "music_resampling_quality", dumb_resampling_quality);
   if (freq_index != old_fi || music_buffer_size != old_mbs) {
        music_freq = mfreq_list[freq_index];
        set_config_int("main", "music_freq", music_freq );
        set_config_int("main", "music_buffer_size", music_buffer_size );
        reset_music();
   }
#endif
   set_config_int("main", "ai_wait_timing", ai_wait_timing );
   set_config_int("main", "fast_spinner", ( fast_spinner ? 1 : 0) );
   set_config_int("main", "enable_sound", ( enable_sound ? 1 : 0) );
   set_config_int("main", "enable_music", ( enable_music ? 1 : 0) );
   set_config_int("main", "sound_vol", sound_vol );
   set_config_int("main", "music_vol", music_vol );
   flush_config_file();
   show_mouse(screen);
   unscare_mouse();
   return ADIME_REDRAW;
}

static void initgamedlg() {
   int bs = numsq - 4; if (bs < 0) bs = 0;
   qdlg("Game Setup",
        ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 160,
        "Players [2-6]:%pint[2,6]"
        "Board Size:%list[,Tiny;Small;Medium;Large;Extra Large]"
        "Hand Size:%pint[3,6]"
        "Video/Sound:%button[Configure...]"
        ,
        &numplayers,
        &bs,
        &piecesowned,
        &sound_options_dlg
   );
   numsq = 4 +bs;
   set_config_string("main", "data_dir",data_dir);
   set_config_string("main", "music_dir", music_dir);
   set_config_int("main", "num_players", numplayers );
   set_config_int("main", "board_size", numsq );
   set_config_int("main", "hand_size", piecesowned );
   set_config_int("main", "ai_test", ai_test );
}
#undef MIDISUBST


static void initplayerdlg(int pidx) {
   int ps = player[pidx].ai_var; // values should be set from the cfg file.
   char ttl[50];
   snprintf(ttl,sizeof(ttl),"Player %i Setup", pidx);
   char playername[20], playerai[20];
   snprintf(playername, sizeof playername, "player%i_name", pidx);
   snprintf(playerai, sizeof playerai, "player%i_ai", pidx);
   qdlg(ttl,
                 ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 200,
                 "Name:%string[26]"
                 "Player Style:%vlist[]"
                 ,
                 player[pidx].name,
                 &ps,
                 ai_name_list,
                 NUM_AI_NAMES
   );
   set_config_string("main", playername, player[pidx].name);
   set_config_int("main", playerai, ps);
   player[pidx].ai_func = ai_list[ps].ai_func;
   player[pidx].ai_var  = ai_list[ps].ai_var;
}

void qfe_gamesetup() {
   set_mood(GM_TITLE);
   initgamedlg();
   for (int i = 1; i <= numplayers; i++) {
   	initplayerdlg(i);
   }
   flush_config_file();
}

